/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelImportJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelImportJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary;

public class ListModelImportJobsPublisher
implements SdkPublisher<ListModelImportJobsResponse> {
    private final BedrockAsyncClient client;
    private final ListModelImportJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelImportJobsPublisher(BedrockAsyncClient client, ListModelImportJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelImportJobsPublisher(BedrockAsyncClient client, ListModelImportJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelImportJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelImportJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelImportJobSummary> modelImportJobSummaries() {
        return this.flatMapIterable(response -> response.modelImportJobSummaries());
    }

    private class ListModelImportJobsResponseFetcher
    implements AsyncPageFetcher<ListModelImportJobsResponse> {
        private ListModelImportJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelImportJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelImportJobsResponse> nextPage(ListModelImportJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelImportJobsPublisher.this.client.listModelImportJobs(ListModelImportJobsPublisher.this.firstRequest);
            }
            return ListModelImportJobsPublisher.this.client.listModelImportJobs((ListModelImportJobsRequest)((Object)ListModelImportJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

