/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsRequest;
import software.amazon.awssdk.services.bedrock.model.ListModelCopyJobsResponse;
import software.amazon.awssdk.services.bedrock.model.ModelCopyJobSummary;

public class ListModelCopyJobsPublisher
implements SdkPublisher<ListModelCopyJobsResponse> {
    private final BedrockAsyncClient client;
    private final ListModelCopyJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelCopyJobsPublisher(BedrockAsyncClient client, ListModelCopyJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelCopyJobsPublisher(BedrockAsyncClient client, ListModelCopyJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelCopyJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelCopyJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelCopyJobSummary> modelCopyJobSummaries() {
        return this.flatMapIterable(response -> response.modelCopyJobSummaries());
    }

    private class ListModelCopyJobsResponseFetcher
    implements AsyncPageFetcher<ListModelCopyJobsResponse> {
        private ListModelCopyJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCopyJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelCopyJobsResponse> nextPage(ListModelCopyJobsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCopyJobsPublisher.this.client.listModelCopyJobs(ListModelCopyJobsPublisher.this.firstRequest);
            }
            return ListModelCopyJobsPublisher.this.client.listModelCopyJobs((ListModelCopyJobsRequest)((Object)ListModelCopyJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

