/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailOutputConfiguration;
import software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailsOutputConfigurationCopier;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEnforcedGuardrailsConfigurationResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListEnforcedGuardrailsConfigurationResponse> {
    private static final SdkField<List<AccountEnforcedGuardrailOutputConfiguration>> GUARDRAILS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("guardrailsConfig").getter(ListEnforcedGuardrailsConfigurationResponse.getter(ListEnforcedGuardrailsConfigurationResponse::guardrailsConfig)).setter(ListEnforcedGuardrailsConfigurationResponse.setter(Builder::guardrailsConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailsConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccountEnforcedGuardrailOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEnforcedGuardrailsConfigurationResponse.getter(ListEnforcedGuardrailsConfigurationResponse::nextToken)).setter(ListEnforcedGuardrailsConfigurationResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAILS_CONFIG_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEnforcedGuardrailsConfigurationResponse.memberNameToFieldInitializer();
    private final List<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig;
    private final String nextToken;

    private ListEnforcedGuardrailsConfigurationResponse(BuilderImpl builder) {
        super(builder);
        this.guardrailsConfig = builder.guardrailsConfig;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasGuardrailsConfig() {
        return this.guardrailsConfig != null && !(this.guardrailsConfig instanceof SdkAutoConstructList);
    }

    public final List<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig() {
        return this.guardrailsConfig;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuardrailsConfig() ? this.guardrailsConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEnforcedGuardrailsConfigurationResponse)) {
            return false;
        }
        ListEnforcedGuardrailsConfigurationResponse other = (ListEnforcedGuardrailsConfigurationResponse)((Object)obj);
        return this.hasGuardrailsConfig() == other.hasGuardrailsConfig() && Objects.equals(this.guardrailsConfig(), other.guardrailsConfig()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEnforcedGuardrailsConfigurationResponse").add("GuardrailsConfig", this.hasGuardrailsConfig() ? this.guardrailsConfig() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailsConfig": {
                return Optional.ofNullable(clazz.cast(this.guardrailsConfig()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("guardrailsConfig", GUARDRAILS_CONFIG_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEnforcedGuardrailsConfigurationResponse, T> g) {
        return obj -> g.apply((ListEnforcedGuardrailsConfigurationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEnforcedGuardrailsConfigurationResponse model) {
            super(model);
            this.guardrailsConfig(model.guardrailsConfig);
            this.nextToken(model.nextToken);
        }

        public final List<AccountEnforcedGuardrailOutputConfiguration.Builder> getGuardrailsConfig() {
            List<AccountEnforcedGuardrailOutputConfiguration.Builder> result = AccountEnforcedGuardrailsOutputConfigurationCopier.copyToBuilder(this.guardrailsConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGuardrailsConfig(Collection<AccountEnforcedGuardrailOutputConfiguration.BuilderImpl> guardrailsConfig) {
            this.guardrailsConfig = AccountEnforcedGuardrailsOutputConfigurationCopier.copyFromBuilder(guardrailsConfig);
        }

        @Override
        public final Builder guardrailsConfig(Collection<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig) {
            this.guardrailsConfig = AccountEnforcedGuardrailsOutputConfigurationCopier.copy(guardrailsConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailsConfig(AccountEnforcedGuardrailOutputConfiguration ... guardrailsConfig) {
            this.guardrailsConfig(Arrays.asList(guardrailsConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailsConfig(Consumer<AccountEnforcedGuardrailOutputConfiguration.Builder> ... guardrailsConfig) {
            this.guardrailsConfig(Stream.of(guardrailsConfig).map(c -> (AccountEnforcedGuardrailOutputConfiguration)((AccountEnforcedGuardrailOutputConfiguration.Builder)AccountEnforcedGuardrailOutputConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEnforcedGuardrailsConfigurationResponse build() {
            return new ListEnforcedGuardrailsConfigurationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEnforcedGuardrailsConfigurationResponse> {
        public Builder guardrailsConfig(Collection<AccountEnforcedGuardrailOutputConfiguration> var1);

        public Builder guardrailsConfig(AccountEnforcedGuardrailOutputConfiguration ... var1);

        public Builder guardrailsConfig(Consumer<AccountEnforcedGuardrailOutputConfiguration.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

