/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AccountEnforcedGuardrailOutputConfiguration;
import software.amazon.awssdk.services.bedrock.model.ListEnforcedGuardrailsConfigurationRequest;
import software.amazon.awssdk.services.bedrock.model.ListEnforcedGuardrailsConfigurationResponse;

public class ListEnforcedGuardrailsConfigurationIterable
implements SdkIterable<ListEnforcedGuardrailsConfigurationResponse> {
    private final BedrockClient client;
    private final ListEnforcedGuardrailsConfigurationRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnforcedGuardrailsConfigurationIterable(BedrockClient client, ListEnforcedGuardrailsConfigurationRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnforcedGuardrailsConfigurationResponseFetcher();
    }

    public Iterator<ListEnforcedGuardrailsConfigurationResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<AccountEnforcedGuardrailOutputConfiguration> guardrailsConfig() {
        Function<ListEnforcedGuardrailsConfigurationResponse, Iterator> getIterator = response -> {
            if (response != null && response.guardrailsConfig() != null) {
                return response.guardrailsConfig().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnforcedGuardrailsConfigurationResponseFetcher
    implements SyncPageFetcher<ListEnforcedGuardrailsConfigurationResponse> {
        private ListEnforcedGuardrailsConfigurationResponseFetcher() {
        }

        public boolean hasNextPage(ListEnforcedGuardrailsConfigurationResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnforcedGuardrailsConfigurationResponse nextPage(ListEnforcedGuardrailsConfigurationResponse previousPage) {
            if (previousPage == null) {
                return ListEnforcedGuardrailsConfigurationIterable.this.client.listEnforcedGuardrailsConfiguration(ListEnforcedGuardrailsConfigurationIterable.this.firstRequest);
            }
            return ListEnforcedGuardrailsConfigurationIterable.this.client.listEnforcedGuardrailsConfiguration((ListEnforcedGuardrailsConfigurationRequest)((Object)ListEnforcedGuardrailsConfigurationIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

