/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.BedrockRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFoundationModelAgreementRequest
extends BedrockRequest
implements ToCopyableBuilder<Builder, CreateFoundationModelAgreementRequest> {
    private static final SdkField<String> OFFER_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("offerToken").getter(CreateFoundationModelAgreementRequest.getter(CreateFoundationModelAgreementRequest::offerToken)).setter(CreateFoundationModelAgreementRequest.setter(Builder::offerToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offerToken").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(CreateFoundationModelAgreementRequest.getter(CreateFoundationModelAgreementRequest::modelId)).setter(CreateFoundationModelAgreementRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFFER_TOKEN_FIELD, MODEL_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateFoundationModelAgreementRequest.memberNameToFieldInitializer();
    private final String offerToken;
    private final String modelId;

    private CreateFoundationModelAgreementRequest(BuilderImpl builder) {
        super(builder);
        this.offerToken = builder.offerToken;
        this.modelId = builder.modelId;
    }

    public final String offerToken() {
        return this.offerToken;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.offerToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFoundationModelAgreementRequest)) {
            return false;
        }
        CreateFoundationModelAgreementRequest other = (CreateFoundationModelAgreementRequest)((Object)obj);
        return Objects.equals(this.offerToken(), other.offerToken()) && Objects.equals(this.modelId(), other.modelId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateFoundationModelAgreementRequest").add("OfferToken", (Object)this.offerToken()).add("ModelId", (Object)this.modelId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "offerToken": {
                return Optional.ofNullable(clazz.cast(this.offerToken()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("offerToken", OFFER_TOKEN_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateFoundationModelAgreementRequest, T> g) {
        return obj -> g.apply((CreateFoundationModelAgreementRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockRequest.BuilderImpl
    implements Builder {
        private String offerToken;
        private String modelId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFoundationModelAgreementRequest model) {
            super(model);
            this.offerToken(model.offerToken);
            this.modelId(model.modelId);
        }

        public final String getOfferToken() {
            return this.offerToken;
        }

        public final void setOfferToken(String offerToken) {
            this.offerToken = offerToken;
        }

        @Override
        public final Builder offerToken(String offerToken) {
            this.offerToken = offerToken;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFoundationModelAgreementRequest build() {
            return new CreateFoundationModelAgreementRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFoundationModelAgreementRequest> {
        public Builder offerToken(String var1);

        public Builder modelId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

