/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildWorkflowSummary;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsRequest;
import software.amazon.awssdk.services.bedrock.model.ListAutomatedReasoningPolicyBuildWorkflowsResponse;

public class ListAutomatedReasoningPolicyBuildWorkflowsPublisher
implements SdkPublisher<ListAutomatedReasoningPolicyBuildWorkflowsResponse> {
    private final BedrockAsyncClient client;
    private final ListAutomatedReasoningPolicyBuildWorkflowsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutomatedReasoningPolicyBuildWorkflowsPublisher(BedrockAsyncClient client, ListAutomatedReasoningPolicyBuildWorkflowsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutomatedReasoningPolicyBuildWorkflowsPublisher(BedrockAsyncClient client, ListAutomatedReasoningPolicyBuildWorkflowsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutomatedReasoningPolicyBuildWorkflowsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutomatedReasoningPolicyBuildWorkflowsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutomatedReasoningPolicyBuildWorkflowSummary> automatedReasoningPolicyBuildWorkflowSummaries() {
        Function<ListAutomatedReasoningPolicyBuildWorkflowsResponse, Iterator> getIterator = response -> {
            if (response != null && response.automatedReasoningPolicyBuildWorkflowSummaries() != null) {
                return response.automatedReasoningPolicyBuildWorkflowSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutomatedReasoningPolicyBuildWorkflowsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutomatedReasoningPolicyBuildWorkflowsResponseFetcher
    implements AsyncPageFetcher<ListAutomatedReasoningPolicyBuildWorkflowsResponse> {
        private ListAutomatedReasoningPolicyBuildWorkflowsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutomatedReasoningPolicyBuildWorkflowsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutomatedReasoningPolicyBuildWorkflowsResponse> nextPage(ListAutomatedReasoningPolicyBuildWorkflowsResponse previousPage) {
            if (previousPage == null) {
                return ListAutomatedReasoningPolicyBuildWorkflowsPublisher.this.client.listAutomatedReasoningPolicyBuildWorkflows(ListAutomatedReasoningPolicyBuildWorkflowsPublisher.this.firstRequest);
            }
            return ListAutomatedReasoningPolicyBuildWorkflowsPublisher.this.client.listAutomatedReasoningPolicyBuildWorkflows((ListAutomatedReasoningPolicyBuildWorkflowsRequest)((Object)ListAutomatedReasoningPolicyBuildWorkflowsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

