/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionRuleIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation> {
    private static final SdkField<List<String>> RULE_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ruleIds").getter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.getter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation::ruleIds)).setter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.setter(Builder::ruleIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SCENARIO_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scenarioExpression").getter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.getter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation::scenarioExpression)).setter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.setter(Builder::scenarioExpression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scenarioExpression").build()}).build();
    private static final SdkField<String> FEEDBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("feedback").getter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.getter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation::feedback)).setter(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.setter(Builder::feedback)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feedback").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_IDS_FIELD, SCENARIO_EXPRESSION_FIELD, FEEDBACK_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> ruleIds;
    private final String scenarioExpression;
    private final String feedback;

    private AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation(BuilderImpl builder) {
        this.ruleIds = builder.ruleIds;
        this.scenarioExpression = builder.scenarioExpression;
        this.feedback = builder.feedback;
    }

    public final boolean hasRuleIds() {
        return this.ruleIds != null && !(this.ruleIds instanceof SdkAutoConstructList);
    }

    public final List<String> ruleIds() {
        return this.ruleIds;
    }

    public final String scenarioExpression() {
        return this.scenarioExpression;
    }

    public final String feedback() {
        return this.feedback;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRuleIds() ? this.ruleIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.scenarioExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedback());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation)) {
            return false;
        }
        AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation other = (AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation)obj;
        return this.hasRuleIds() == other.hasRuleIds() && Objects.equals(this.ruleIds(), other.ruleIds()) && Objects.equals(this.scenarioExpression(), other.scenarioExpression()) && Objects.equals(this.feedback(), other.feedback());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation").add("RuleIds", this.hasRuleIds() ? this.ruleIds() : null).add("ScenarioExpression", (Object)(this.scenarioExpression() == null ? null : "*** Sensitive Data Redacted ***")).add("Feedback", (Object)(this.feedback() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ruleIds": {
                return Optional.ofNullable(clazz.cast(this.ruleIds()));
            }
            case "scenarioExpression": {
                return Optional.ofNullable(clazz.cast(this.scenarioExpression()));
            }
            case "feedback": {
                return Optional.ofNullable(clazz.cast(this.feedback()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ruleIds", RULE_IDS_FIELD);
        map.put("scenarioExpression", SCENARIO_EXPRESSION_FIELD);
        map.put("feedback", FEEDBACK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> ruleIds = DefaultSdkAutoConstructList.getInstance();
        private String scenarioExpression;
        private String feedback;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation model) {
            this.ruleIds(model.ruleIds);
            this.scenarioExpression(model.scenarioExpression);
            this.feedback(model.feedback);
        }

        public final Collection<String> getRuleIds() {
            if (this.ruleIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.ruleIds;
        }

        public final void setRuleIds(Collection<String> ruleIds) {
            this.ruleIds = AutomatedReasoningPolicyDefinitionRuleIdListCopier.copy(ruleIds);
        }

        @Override
        public final Builder ruleIds(Collection<String> ruleIds) {
            this.ruleIds = AutomatedReasoningPolicyDefinitionRuleIdListCopier.copy(ruleIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ruleIds(String ... ruleIds) {
            this.ruleIds(Arrays.asList(ruleIds));
            return this;
        }

        public final String getScenarioExpression() {
            return this.scenarioExpression;
        }

        public final void setScenarioExpression(String scenarioExpression) {
            this.scenarioExpression = scenarioExpression;
        }

        @Override
        public final Builder scenarioExpression(String scenarioExpression) {
            this.scenarioExpression = scenarioExpression;
            return this;
        }

        public final String getFeedback() {
            return this.feedback;
        }

        public final void setFeedback(String feedback) {
            this.feedback = feedback;
        }

        @Override
        public final Builder feedback(String feedback) {
            this.feedback = feedback;
            return this;
        }

        public AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation build() {
            return new AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyUpdateFromScenarioFeedbackAnnotation> {
        public Builder ruleIds(Collection<String> var1);

        public Builder ruleIds(String ... var1);

        public Builder scenarioExpression(String var1);

        public Builder feedback(String var1);
    }
}

