/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatement;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningLogicStatementListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningCheckScenario
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningCheckScenario> {
    private static final SdkField<List<AutomatedReasoningLogicStatement>> STATEMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("statements").getter(AutomatedReasoningCheckScenario.getter(AutomatedReasoningCheckScenario::statements)).setter(AutomatedReasoningCheckScenario.setter(Builder::statements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningLogicStatement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATEMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningCheckScenario.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<AutomatedReasoningLogicStatement> statements;

    private AutomatedReasoningCheckScenario(BuilderImpl builder) {
        this.statements = builder.statements;
    }

    public final boolean hasStatements() {
        return this.statements != null && !(this.statements instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningLogicStatement> statements() {
        return this.statements;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStatements() ? this.statements() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckScenario)) {
            return false;
        }
        AutomatedReasoningCheckScenario other = (AutomatedReasoningCheckScenario)obj;
        return this.hasStatements() == other.hasStatements() && Objects.equals(this.statements(), other.statements());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningCheckScenario").add("Statements", this.hasStatements() ? this.statements() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "statements": {
                return Optional.ofNullable(clazz.cast(this.statements()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<AutomatedReasoningLogicStatement>>> map = new HashMap<String, SdkField<List<AutomatedReasoningLogicStatement>>>();
        map.put("statements", STATEMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckScenario, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckScenario)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<AutomatedReasoningLogicStatement> statements = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckScenario model) {
            this.statements(model.statements);
        }

        public final List<AutomatedReasoningLogicStatement.Builder> getStatements() {
            List<AutomatedReasoningLogicStatement.Builder> result = AutomatedReasoningLogicStatementListCopier.copyToBuilder(this.statements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatements(Collection<AutomatedReasoningLogicStatement.BuilderImpl> statements) {
            this.statements = AutomatedReasoningLogicStatementListCopier.copyFromBuilder(statements);
        }

        @Override
        public final Builder statements(Collection<AutomatedReasoningLogicStatement> statements) {
            this.statements = AutomatedReasoningLogicStatementListCopier.copy(statements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(AutomatedReasoningLogicStatement ... statements) {
            this.statements(Arrays.asList(statements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statements(Consumer<AutomatedReasoningLogicStatement.Builder> ... statements) {
            this.statements(Stream.of(statements).map(c -> (AutomatedReasoningLogicStatement)((AutomatedReasoningLogicStatement.Builder)AutomatedReasoningLogicStatement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutomatedReasoningCheckScenario build() {
            return new AutomatedReasoningCheckScenario(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningCheckScenario> {
        public Builder statements(Collection<AutomatedReasoningLogicStatement> var1);

        public Builder statements(AutomatedReasoningLogicStatement ... var1);

        public Builder statements(Consumer<AutomatedReasoningLogicStatement.Builder> ... var1);
    }
}

