/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.Offer;
import software.amazon.awssdk.services.bedrock.model.OffersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListFoundationModelAgreementOffersResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListFoundationModelAgreementOffersResponse> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(ListFoundationModelAgreementOffersResponse.getter(ListFoundationModelAgreementOffersResponse::modelId)).setter(ListFoundationModelAgreementOffersResponse.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<List<Offer>> OFFERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("offers").getter(ListFoundationModelAgreementOffersResponse.getter(ListFoundationModelAgreementOffersResponse::offers)).setter(ListFoundationModelAgreementOffersResponse.setter(Builder::offers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("offers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Offer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, OFFERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListFoundationModelAgreementOffersResponse.memberNameToFieldInitializer();
    private final String modelId;
    private final List<Offer> offers;

    private ListFoundationModelAgreementOffersResponse(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.offers = builder.offers;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final boolean hasOffers() {
        return this.offers != null && !(this.offers instanceof SdkAutoConstructList);
    }

    public final List<Offer> offers() {
        return this.offers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOffers() ? this.offers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFoundationModelAgreementOffersResponse)) {
            return false;
        }
        ListFoundationModelAgreementOffersResponse other = (ListFoundationModelAgreementOffersResponse)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && this.hasOffers() == other.hasOffers() && Objects.equals(this.offers(), other.offers());
    }

    public final String toString() {
        return ToString.builder((String)"ListFoundationModelAgreementOffersResponse").add("ModelId", (Object)this.modelId()).add("Offers", this.hasOffers() ? this.offers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "offers": {
                return Optional.ofNullable(clazz.cast(this.offers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("offers", OFFERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFoundationModelAgreementOffersResponse, T> g) {
        return obj -> g.apply((ListFoundationModelAgreementOffersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String modelId;
        private List<Offer> offers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListFoundationModelAgreementOffersResponse model) {
            super(model);
            this.modelId(model.modelId);
            this.offers(model.offers);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final List<Offer.Builder> getOffers() {
            List<Offer.Builder> result = OffersCopier.copyToBuilder(this.offers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOffers(Collection<Offer.BuilderImpl> offers) {
            this.offers = OffersCopier.copyFromBuilder(offers);
        }

        @Override
        public final Builder offers(Collection<Offer> offers) {
            this.offers = OffersCopier.copy(offers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offers(Offer ... offers) {
            this.offers(Arrays.asList(offers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder offers(Consumer<Offer.Builder> ... offers) {
            this.offers(Stream.of(offers).map(c -> (Offer)((Offer.Builder)Offer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListFoundationModelAgreementOffersResponse build() {
            return new ListFoundationModelAgreementOffersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListFoundationModelAgreementOffersResponse> {
        public Builder modelId(String var1);

        public Builder offers(Collection<Offer> var1);

        public Builder offers(Offer ... var1);

        public Builder offers(Consumer<Offer.Builder> ... var1);
    }
}

