/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicsTierName;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTopicsTier
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTopicsTier> {
    private static final SdkField<String> TIER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tierName").getter(GuardrailTopicsTier.getter(GuardrailTopicsTier::tierNameAsString)).setter(GuardrailTopicsTier.setter(Builder::tierName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tierName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIER_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailTopicsTier.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String tierName;

    private GuardrailTopicsTier(BuilderImpl builder) {
        this.tierName = builder.tierName;
    }

    public final GuardrailTopicsTierName tierName() {
        return GuardrailTopicsTierName.fromValue(this.tierName);
    }

    public final String tierNameAsString() {
        return this.tierName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.tierNameAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopicsTier)) {
            return false;
        }
        GuardrailTopicsTier other = (GuardrailTopicsTier)obj;
        return Objects.equals(this.tierNameAsString(), other.tierNameAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTopicsTier").add("TierName", (Object)(this.tierNameAsString() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "tierName": {
                return Optional.ofNullable(clazz.cast(this.tierNameAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("tierName", TIER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTopicsTier, T> g) {
        return obj -> g.apply((GuardrailTopicsTier)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String tierName;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTopicsTier model) {
            this.tierName(model.tierName);
        }

        public final String getTierName() {
            return this.tierName;
        }

        public final void setTierName(String tierName) {
            this.tierName = tierName;
        }

        @Override
        public final Builder tierName(String tierName) {
            this.tierName = tierName;
            return this;
        }

        @Override
        public final Builder tierName(GuardrailTopicsTierName tierName) {
            this.tierName(tierName == null ? null : tierName.toString());
            return this;
        }

        public GuardrailTopicsTier build() {
            return new GuardrailTopicsTier(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTopicsTier> {
        public Builder tierName(String var1);

        public Builder tierName(GuardrailTopicsTierName var1);
    }
}

