/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AgreementAvailability;
import software.amazon.awssdk.services.bedrock.model.AuthorizationStatus;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.EntitlementAvailability;
import software.amazon.awssdk.services.bedrock.model.RegionAvailability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFoundationModelAvailabilityResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, GetFoundationModelAvailabilityResponse> {
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(GetFoundationModelAvailabilityResponse.getter(GetFoundationModelAvailabilityResponse::modelId)).setter(GetFoundationModelAvailabilityResponse.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<AgreementAvailability> AGREEMENT_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agreementAvailability").getter(GetFoundationModelAvailabilityResponse.getter(GetFoundationModelAvailabilityResponse::agreementAvailability)).setter(GetFoundationModelAvailabilityResponse.setter(Builder::agreementAvailability)).constructor(AgreementAvailability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreementAvailability").build()}).build();
    private static final SdkField<String> AUTHORIZATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationStatus").getter(GetFoundationModelAvailabilityResponse.getter(GetFoundationModelAvailabilityResponse::authorizationStatusAsString)).setter(GetFoundationModelAvailabilityResponse.setter(Builder::authorizationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationStatus").build()}).build();
    private static final SdkField<String> ENTITLEMENT_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entitlementAvailability").getter(GetFoundationModelAvailabilityResponse.getter(GetFoundationModelAvailabilityResponse::entitlementAvailabilityAsString)).setter(GetFoundationModelAvailabilityResponse.setter(Builder::entitlementAvailability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entitlementAvailability").build()}).build();
    private static final SdkField<String> REGION_AVAILABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("regionAvailability").getter(GetFoundationModelAvailabilityResponse.getter(GetFoundationModelAvailabilityResponse::regionAvailabilityAsString)).setter(GetFoundationModelAvailabilityResponse.setter(Builder::regionAvailability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionAvailability").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ID_FIELD, AGREEMENT_AVAILABILITY_FIELD, AUTHORIZATION_STATUS_FIELD, ENTITLEMENT_AVAILABILITY_FIELD, REGION_AVAILABILITY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFoundationModelAvailabilityResponse.memberNameToFieldInitializer();
    private final String modelId;
    private final AgreementAvailability agreementAvailability;
    private final String authorizationStatus;
    private final String entitlementAvailability;
    private final String regionAvailability;

    private GetFoundationModelAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.modelId = builder.modelId;
        this.agreementAvailability = builder.agreementAvailability;
        this.authorizationStatus = builder.authorizationStatus;
        this.entitlementAvailability = builder.entitlementAvailability;
        this.regionAvailability = builder.regionAvailability;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final AgreementAvailability agreementAvailability() {
        return this.agreementAvailability;
    }

    public final AuthorizationStatus authorizationStatus() {
        return AuthorizationStatus.fromValue(this.authorizationStatus);
    }

    public final String authorizationStatusAsString() {
        return this.authorizationStatus;
    }

    public final EntitlementAvailability entitlementAvailability() {
        return EntitlementAvailability.fromValue(this.entitlementAvailability);
    }

    public final String entitlementAvailabilityAsString() {
        return this.entitlementAvailability;
    }

    public final RegionAvailability regionAvailability() {
        return RegionAvailability.fromValue(this.regionAvailability);
    }

    public final String regionAvailabilityAsString() {
        return this.regionAvailability;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agreementAvailability());
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.entitlementAvailabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionAvailabilityAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFoundationModelAvailabilityResponse)) {
            return false;
        }
        GetFoundationModelAvailabilityResponse other = (GetFoundationModelAvailabilityResponse)((Object)obj);
        return Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.agreementAvailability(), other.agreementAvailability()) && Objects.equals(this.authorizationStatusAsString(), other.authorizationStatusAsString()) && Objects.equals(this.entitlementAvailabilityAsString(), other.entitlementAvailabilityAsString()) && Objects.equals(this.regionAvailabilityAsString(), other.regionAvailabilityAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetFoundationModelAvailabilityResponse").add("ModelId", (Object)this.modelId()).add("AgreementAvailability", (Object)this.agreementAvailability()).add("AuthorizationStatus", (Object)this.authorizationStatusAsString()).add("EntitlementAvailability", (Object)this.entitlementAvailabilityAsString()).add("RegionAvailability", (Object)this.regionAvailabilityAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "agreementAvailability": {
                return Optional.ofNullable(clazz.cast(this.agreementAvailability()));
            }
            case "authorizationStatus": {
                return Optional.ofNullable(clazz.cast(this.authorizationStatusAsString()));
            }
            case "entitlementAvailability": {
                return Optional.ofNullable(clazz.cast(this.entitlementAvailabilityAsString()));
            }
            case "regionAvailability": {
                return Optional.ofNullable(clazz.cast(this.regionAvailabilityAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modelId", MODEL_ID_FIELD);
        map.put("agreementAvailability", AGREEMENT_AVAILABILITY_FIELD);
        map.put("authorizationStatus", AUTHORIZATION_STATUS_FIELD);
        map.put("entitlementAvailability", ENTITLEMENT_AVAILABILITY_FIELD);
        map.put("regionAvailability", REGION_AVAILABILITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFoundationModelAvailabilityResponse, T> g) {
        return obj -> g.apply((GetFoundationModelAvailabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String modelId;
        private AgreementAvailability agreementAvailability;
        private String authorizationStatus;
        private String entitlementAvailability;
        private String regionAvailability;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFoundationModelAvailabilityResponse model) {
            super(model);
            this.modelId(model.modelId);
            this.agreementAvailability(model.agreementAvailability);
            this.authorizationStatus(model.authorizationStatus);
            this.entitlementAvailability(model.entitlementAvailability);
            this.regionAvailability(model.regionAvailability);
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final AgreementAvailability.Builder getAgreementAvailability() {
            return this.agreementAvailability != null ? this.agreementAvailability.toBuilder() : null;
        }

        public final void setAgreementAvailability(AgreementAvailability.BuilderImpl agreementAvailability) {
            this.agreementAvailability = agreementAvailability != null ? agreementAvailability.build() : null;
        }

        @Override
        public final Builder agreementAvailability(AgreementAvailability agreementAvailability) {
            this.agreementAvailability = agreementAvailability;
            return this;
        }

        public final String getAuthorizationStatus() {
            return this.authorizationStatus;
        }

        public final void setAuthorizationStatus(String authorizationStatus) {
            this.authorizationStatus = authorizationStatus;
        }

        @Override
        public final Builder authorizationStatus(String authorizationStatus) {
            this.authorizationStatus = authorizationStatus;
            return this;
        }

        @Override
        public final Builder authorizationStatus(AuthorizationStatus authorizationStatus) {
            this.authorizationStatus(authorizationStatus == null ? null : authorizationStatus.toString());
            return this;
        }

        public final String getEntitlementAvailability() {
            return this.entitlementAvailability;
        }

        public final void setEntitlementAvailability(String entitlementAvailability) {
            this.entitlementAvailability = entitlementAvailability;
        }

        @Override
        public final Builder entitlementAvailability(String entitlementAvailability) {
            this.entitlementAvailability = entitlementAvailability;
            return this;
        }

        @Override
        public final Builder entitlementAvailability(EntitlementAvailability entitlementAvailability) {
            this.entitlementAvailability(entitlementAvailability == null ? null : entitlementAvailability.toString());
            return this;
        }

        public final String getRegionAvailability() {
            return this.regionAvailability;
        }

        public final void setRegionAvailability(String regionAvailability) {
            this.regionAvailability = regionAvailability;
        }

        @Override
        public final Builder regionAvailability(String regionAvailability) {
            this.regionAvailability = regionAvailability;
            return this;
        }

        @Override
        public final Builder regionAvailability(RegionAvailability regionAvailability) {
            this.regionAvailability(regionAvailability == null ? null : regionAvailability.toString());
            return this;
        }

        @Override
        public GetFoundationModelAvailabilityResponse build() {
            return new GetFoundationModelAvailabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFoundationModelAvailabilityResponse> {
        public Builder modelId(String var1);

        public Builder agreementAvailability(AgreementAvailability var1);

        default public Builder agreementAvailability(Consumer<AgreementAvailability.Builder> agreementAvailability) {
            return this.agreementAvailability((AgreementAvailability)((AgreementAvailability.Builder)AgreementAvailability.builder().applyMutation(agreementAvailability)).build());
        }

        public Builder authorizationStatus(String var1);

        public Builder authorizationStatus(AuthorizationStatus var1);

        public Builder entitlementAvailability(String var1);

        public Builder entitlementAvailability(EntitlementAvailability var1);

        public Builder regionAvailability(String var1);

        public Builder regionAvailability(RegionAvailability var1);
    }
}

