/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotation;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyAnnotationStatus;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStep;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyBuildStepListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyBuildLogEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyBuildLogEntry> {
    private static final SdkField<AutomatedReasoningPolicyAnnotation> ANNOTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("annotation").getter(AutomatedReasoningPolicyBuildLogEntry.getter(AutomatedReasoningPolicyBuildLogEntry::annotation)).setter(AutomatedReasoningPolicyBuildLogEntry.setter(Builder::annotation)).constructor(AutomatedReasoningPolicyAnnotation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotation").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AutomatedReasoningPolicyBuildLogEntry.getter(AutomatedReasoningPolicyBuildLogEntry::statusAsString)).setter(AutomatedReasoningPolicyBuildLogEntry.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<AutomatedReasoningPolicyBuildStep>> BUILD_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("buildSteps").getter(AutomatedReasoningPolicyBuildLogEntry.getter(AutomatedReasoningPolicyBuildLogEntry::buildSteps)).setter(AutomatedReasoningPolicyBuildLogEntry.setter(Builder::buildSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("buildSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomatedReasoningPolicyBuildStep::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_FIELD, STATUS_FIELD, BUILD_STEPS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyBuildLogEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningPolicyAnnotation annotation;
    private final String status;
    private final List<AutomatedReasoningPolicyBuildStep> buildSteps;

    private AutomatedReasoningPolicyBuildLogEntry(BuilderImpl builder) {
        this.annotation = builder.annotation;
        this.status = builder.status;
        this.buildSteps = builder.buildSteps;
    }

    public final AutomatedReasoningPolicyAnnotation annotation() {
        return this.annotation;
    }

    public final AutomatedReasoningPolicyAnnotationStatus status() {
        return AutomatedReasoningPolicyAnnotationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasBuildSteps() {
        return this.buildSteps != null && !(this.buildSteps instanceof SdkAutoConstructList);
    }

    public final List<AutomatedReasoningPolicyBuildStep> buildSteps() {
        return this.buildSteps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.annotation());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBuildSteps() ? this.buildSteps() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildLogEntry)) {
            return false;
        }
        AutomatedReasoningPolicyBuildLogEntry other = (AutomatedReasoningPolicyBuildLogEntry)obj;
        return Objects.equals(this.annotation(), other.annotation()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasBuildSteps() == other.hasBuildSteps() && Objects.equals(this.buildSteps(), other.buildSteps());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyBuildLogEntry").add("Annotation", (Object)this.annotation()).add("Status", (Object)this.statusAsString()).add("BuildSteps", this.hasBuildSteps() ? this.buildSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "annotation": {
                return Optional.ofNullable(clazz.cast(this.annotation()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "buildSteps": {
                return Optional.ofNullable(clazz.cast(this.buildSteps()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("annotation", ANNOTATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("buildSteps", BUILD_STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildLogEntry, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildLogEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningPolicyAnnotation annotation;
        private String status;
        private List<AutomatedReasoningPolicyBuildStep> buildSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildLogEntry model) {
            this.annotation(model.annotation);
            this.status(model.status);
            this.buildSteps(model.buildSteps);
        }

        public final AutomatedReasoningPolicyAnnotation.Builder getAnnotation() {
            return this.annotation != null ? this.annotation.toBuilder() : null;
        }

        public final void setAnnotation(AutomatedReasoningPolicyAnnotation.BuilderImpl annotation) {
            this.annotation = annotation != null ? annotation.build() : null;
        }

        @Override
        public final Builder annotation(AutomatedReasoningPolicyAnnotation annotation) {
            this.annotation = annotation;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AutomatedReasoningPolicyAnnotationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<AutomatedReasoningPolicyBuildStep.Builder> getBuildSteps() {
            List<AutomatedReasoningPolicyBuildStep.Builder> result = AutomatedReasoningPolicyBuildStepListCopier.copyToBuilder(this.buildSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBuildSteps(Collection<AutomatedReasoningPolicyBuildStep.BuilderImpl> buildSteps) {
            this.buildSteps = AutomatedReasoningPolicyBuildStepListCopier.copyFromBuilder(buildSteps);
        }

        @Override
        public final Builder buildSteps(Collection<AutomatedReasoningPolicyBuildStep> buildSteps) {
            this.buildSteps = AutomatedReasoningPolicyBuildStepListCopier.copy(buildSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildSteps(AutomatedReasoningPolicyBuildStep ... buildSteps) {
            this.buildSteps(Arrays.asList(buildSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder buildSteps(Consumer<AutomatedReasoningPolicyBuildStep.Builder> ... buildSteps) {
            this.buildSteps(Stream.of(buildSteps).map(c -> (AutomatedReasoningPolicyBuildStep)((AutomatedReasoningPolicyBuildStep.Builder)AutomatedReasoningPolicyBuildStep.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AutomatedReasoningPolicyBuildLogEntry build() {
            return new AutomatedReasoningPolicyBuildLogEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyBuildLogEntry> {
        public Builder annotation(AutomatedReasoningPolicyAnnotation var1);

        default public Builder annotation(Consumer<AutomatedReasoningPolicyAnnotation.Builder> annotation) {
            return this.annotation((AutomatedReasoningPolicyAnnotation)((AutomatedReasoningPolicyAnnotation.Builder)AutomatedReasoningPolicyAnnotation.builder().applyMutation(annotation)).build());
        }

        public Builder status(String var1);

        public Builder status(AutomatedReasoningPolicyAnnotationStatus var1);

        public Builder buildSteps(Collection<AutomatedReasoningPolicyBuildStep> var1);

        public Builder buildSteps(AutomatedReasoningPolicyBuildStep ... var1);

        public Builder buildSteps(Consumer<AutomatedReasoningPolicyBuildStep.Builder> ... var1);
    }
}

