/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.ListPromptRoutersRequest;
import software.amazon.awssdk.services.bedrock.model.ListPromptRoutersResponse;
import software.amazon.awssdk.services.bedrock.model.PromptRouterSummary;

public class ListPromptRoutersIterable
implements SdkIterable<ListPromptRoutersResponse> {
    private final BedrockClient client;
    private final ListPromptRoutersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPromptRoutersIterable(BedrockClient client, ListPromptRoutersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPromptRoutersResponseFetcher();
    }

    public Iterator<ListPromptRoutersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PromptRouterSummary> promptRouterSummaries() {
        Function<ListPromptRoutersResponse, Iterator> getIterator = response -> {
            if (response != null && response.promptRouterSummaries() != null) {
                return response.promptRouterSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPromptRoutersResponseFetcher
    implements SyncPageFetcher<ListPromptRoutersResponse> {
        private ListPromptRoutersResponseFetcher() {
        }

        public boolean hasNextPage(ListPromptRoutersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPromptRoutersResponse nextPage(ListPromptRoutersResponse previousPage) {
            if (previousPage == null) {
                return ListPromptRoutersIterable.this.client.listPromptRouters(ListPromptRoutersIterable.this.firstRequest);
            }
            return ListPromptRoutersIterable.this.client.listPromptRouters((ListPromptRoutersRequest)((Object)ListPromptRoutersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

