/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrock.BedrockAsyncClient;
import software.amazon.awssdk.services.bedrock.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrock.model.CustomModelDeploymentSummary;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsRequest;
import software.amazon.awssdk.services.bedrock.model.ListCustomModelDeploymentsResponse;

public class ListCustomModelDeploymentsPublisher
implements SdkPublisher<ListCustomModelDeploymentsResponse> {
    private final BedrockAsyncClient client;
    private final ListCustomModelDeploymentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCustomModelDeploymentsPublisher(BedrockAsyncClient client, ListCustomModelDeploymentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCustomModelDeploymentsPublisher(BedrockAsyncClient client, ListCustomModelDeploymentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCustomModelDeploymentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCustomModelDeploymentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CustomModelDeploymentSummary> modelDeploymentSummaries() {
        Function<ListCustomModelDeploymentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelDeploymentSummaries() != null) {
                return response.modelDeploymentSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCustomModelDeploymentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCustomModelDeploymentsResponseFetcher
    implements AsyncPageFetcher<ListCustomModelDeploymentsResponse> {
        private ListCustomModelDeploymentsResponseFetcher() {
        }

        public boolean hasNextPage(ListCustomModelDeploymentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCustomModelDeploymentsResponse> nextPage(ListCustomModelDeploymentsResponse previousPage) {
            if (previousPage == null) {
                return ListCustomModelDeploymentsPublisher.this.client.listCustomModelDeployments(ListCustomModelDeploymentsPublisher.this.firstRequest);
            }
            return ListCustomModelDeploymentsPublisher.this.client.listCustomModelDeployments((ListCustomModelDeploymentsRequest)((Object)ListCustomModelDeploymentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

