/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.RequestMetadataBaseFilters;
import software.amazon.awssdk.services.bedrock.model.RequestMetadataFiltersListCopier;
import software.amazon.awssdk.services.bedrock.model.RequestMetadataMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RequestMetadataFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RequestMetadataFilters> {
    private static final SdkField<Map<String, String>> EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("equals").getter(RequestMetadataFilters.getter(RequestMetadataFilters::equalsValue)).setter(RequestMetadataFilters.setter(Builder::equalsValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("equals").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> NOT_EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("notEquals").getter(RequestMetadataFilters.getter(RequestMetadataFilters::notEquals)).setter(RequestMetadataFilters.setter(Builder::notEquals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("notEquals").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<RequestMetadataBaseFilters>> AND_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("andAll").getter(RequestMetadataFilters.getter(RequestMetadataFilters::andAll)).setter(RequestMetadataFilters.setter(Builder::andAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("andAll").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestMetadataBaseFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<RequestMetadataBaseFilters>> OR_ALL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("orAll").getter(RequestMetadataFilters.getter(RequestMetadataFilters::orAll)).setter(RequestMetadataFilters.setter(Builder::orAll)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orAll").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RequestMetadataBaseFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EQUALS_FIELD, NOT_EQUALS_FIELD, AND_ALL_FIELD, OR_ALL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RequestMetadataFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Map<String, String> equalsValue;
    private final Map<String, String> notEquals;
    private final List<RequestMetadataBaseFilters> andAll;
    private final List<RequestMetadataBaseFilters> orAll;
    private final Type type;

    private RequestMetadataFilters(BuilderImpl builder) {
        this.equalsValue = builder.equalsValue;
        this.notEquals = builder.notEquals;
        this.andAll = builder.andAll;
        this.orAll = builder.orAll;
        this.type = builder.type;
    }

    public final boolean hasEqualsValue() {
        return this.equalsValue != null && !(this.equalsValue instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> equalsValue() {
        return this.equalsValue;
    }

    public final boolean hasNotEquals() {
        return this.notEquals != null && !(this.notEquals instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> notEquals() {
        return this.notEquals;
    }

    public final boolean hasAndAll() {
        return this.andAll != null && !(this.andAll instanceof SdkAutoConstructList);
    }

    public final List<RequestMetadataBaseFilters> andAll() {
        return this.andAll;
    }

    public final boolean hasOrAll() {
        return this.orAll != null && !(this.orAll instanceof SdkAutoConstructList);
    }

    public final List<RequestMetadataBaseFilters> orAll() {
        return this.orAll;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEqualsValue() ? this.equalsValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotEquals() ? this.notEquals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAndAll() ? this.andAll() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrAll() ? this.orAll() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RequestMetadataFilters)) {
            return false;
        }
        RequestMetadataFilters other = (RequestMetadataFilters)obj;
        return this.hasEqualsValue() == other.hasEqualsValue() && Objects.equals(this.equalsValue(), other.equalsValue()) && this.hasNotEquals() == other.hasNotEquals() && Objects.equals(this.notEquals(), other.notEquals()) && this.hasAndAll() == other.hasAndAll() && Objects.equals(this.andAll(), other.andAll()) && this.hasOrAll() == other.hasOrAll() && Objects.equals(this.orAll(), other.orAll());
    }

    public final String toString() {
        return ToString.builder((String)"RequestMetadataFilters").add("Equals", (Object)(this.equalsValue() == null ? null : "*** Sensitive Data Redacted ***")).add("NotEquals", (Object)(this.notEquals() == null ? null : "*** Sensitive Data Redacted ***")).add("AndAll", this.hasAndAll() ? this.andAll() : null).add("OrAll", this.hasOrAll() ? this.orAll() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "equals": {
                return Optional.ofNullable(clazz.cast(this.equalsValue()));
            }
            case "notEquals": {
                return Optional.ofNullable(clazz.cast(this.notEquals()));
            }
            case "andAll": {
                return Optional.ofNullable(clazz.cast(this.andAll()));
            }
            case "orAll": {
                return Optional.ofNullable(clazz.cast(this.orAll()));
            }
        }
        return Optional.empty();
    }

    public static RequestMetadataFilters fromEqualsValue(Map<String, String> equalsValue) {
        return (RequestMetadataFilters)RequestMetadataFilters.builder().equalsValue(equalsValue).build();
    }

    public static RequestMetadataFilters fromNotEquals(Map<String, String> notEquals) {
        return (RequestMetadataFilters)RequestMetadataFilters.builder().notEquals(notEquals).build();
    }

    public static RequestMetadataFilters fromAndAll(List<RequestMetadataBaseFilters> andAll) {
        return (RequestMetadataFilters)RequestMetadataFilters.builder().andAll(andAll).build();
    }

    public static RequestMetadataFilters fromOrAll(List<RequestMetadataBaseFilters> orAll) {
        return (RequestMetadataFilters)RequestMetadataFilters.builder().orAll(orAll).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("equals", EQUALS_FIELD);
        map.put("notEquals", NOT_EQUALS_FIELD);
        map.put("andAll", AND_ALL_FIELD);
        map.put("orAll", OR_ALL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RequestMetadataFilters, T> g) {
        return obj -> g.apply((RequestMetadataFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EQUALS,
        NOT_EQUALS,
        AND_ALL,
        OR_ALL,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> equalsValue = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> notEquals = DefaultSdkAutoConstructMap.getInstance();
        private List<RequestMetadataBaseFilters> andAll = DefaultSdkAutoConstructList.getInstance();
        private List<RequestMetadataBaseFilters> orAll = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RequestMetadataFilters model) {
            this.equalsValue(model.equalsValue);
            this.notEquals(model.notEquals);
            this.andAll(model.andAll);
            this.orAll(model.orAll);
        }

        public final Map<String, String> getEqualsValue() {
            if (this.equalsValue instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.equalsValue;
        }

        public final void setEqualsValue(Map<String, String> equalsValue) {
            Map<String, String> oldValue = this.equalsValue;
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
            this.handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
        }

        @Override
        public final Builder equalsValue(Map<String, String> equalsValue) {
            Map<String, String> oldValue = this.equalsValue;
            this.equalsValue = RequestMetadataMapCopier.copy(equalsValue);
            this.handleUnionValueChange(Type.EQUALS, oldValue, this.equalsValue);
            return this;
        }

        public final Map<String, String> getNotEquals() {
            if (this.notEquals instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.notEquals;
        }

        public final void setNotEquals(Map<String, String> notEquals) {
            Map<String, String> oldValue = this.notEquals;
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
            this.handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
        }

        @Override
        public final Builder notEquals(Map<String, String> notEquals) {
            Map<String, String> oldValue = this.notEquals;
            this.notEquals = RequestMetadataMapCopier.copy(notEquals);
            this.handleUnionValueChange(Type.NOT_EQUALS, oldValue, this.notEquals);
            return this;
        }

        public final List<RequestMetadataBaseFilters.Builder> getAndAll() {
            List<RequestMetadataBaseFilters.Builder> result = RequestMetadataFiltersListCopier.copyToBuilder(this.andAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAndAll(Collection<RequestMetadataBaseFilters.BuilderImpl> andAll) {
            List<RequestMetadataBaseFilters> oldValue = this.andAll;
            this.andAll = RequestMetadataFiltersListCopier.copyFromBuilder(andAll);
            this.handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
        }

        @Override
        public final Builder andAll(Collection<RequestMetadataBaseFilters> andAll) {
            List<RequestMetadataBaseFilters> oldValue = this.andAll;
            this.andAll = RequestMetadataFiltersListCopier.copy(andAll);
            this.handleUnionValueChange(Type.AND_ALL, oldValue, this.andAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(RequestMetadataBaseFilters ... andAll) {
            this.andAll(Arrays.asList(andAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder andAll(Consumer<RequestMetadataBaseFilters.Builder> ... andAll) {
            this.andAll(Stream.of(andAll).map(c -> (RequestMetadataBaseFilters)((RequestMetadataBaseFilters.Builder)RequestMetadataBaseFilters.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<RequestMetadataBaseFilters.Builder> getOrAll() {
            List<RequestMetadataBaseFilters.Builder> result = RequestMetadataFiltersListCopier.copyToBuilder(this.orAll);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrAll(Collection<RequestMetadataBaseFilters.BuilderImpl> orAll) {
            List<RequestMetadataBaseFilters> oldValue = this.orAll;
            this.orAll = RequestMetadataFiltersListCopier.copyFromBuilder(orAll);
            this.handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
        }

        @Override
        public final Builder orAll(Collection<RequestMetadataBaseFilters> orAll) {
            List<RequestMetadataBaseFilters> oldValue = this.orAll;
            this.orAll = RequestMetadataFiltersListCopier.copy(orAll);
            this.handleUnionValueChange(Type.OR_ALL, oldValue, this.orAll);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(RequestMetadataBaseFilters ... orAll) {
            this.orAll(Arrays.asList(orAll));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orAll(Consumer<RequestMetadataBaseFilters.Builder> ... orAll) {
            this.orAll(Stream.of(orAll).map(c -> (RequestMetadataBaseFilters)((RequestMetadataBaseFilters.Builder)RequestMetadataBaseFilters.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RequestMetadataFilters build() {
            return new RequestMetadataFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RequestMetadataFilters> {
        public Builder equalsValue(Map<String, String> var1);

        public Builder notEquals(Map<String, String> var1);

        public Builder andAll(Collection<RequestMetadataBaseFilters> var1);

        public Builder andAll(RequestMetadataBaseFilters ... var1);

        public Builder andAll(Consumer<RequestMetadataBaseFilters.Builder> ... var1);

        public Builder orAll(Collection<RequestMetadataBaseFilters> var1);

        public Builder orAll(RequestMetadataBaseFilters ... var1);

        public Builder orAll(Consumer<RequestMetadataBaseFilters.Builder> ... var1);
    }
}

