/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.InferenceProfileSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInferenceProfilesResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListInferenceProfilesResponse> {
    private static final SdkField<List<InferenceProfileSummary>> INFERENCE_PROFILE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inferenceProfileSummaries").getter(ListInferenceProfilesResponse.getter(ListInferenceProfilesResponse::inferenceProfileSummaries)).setter(ListInferenceProfilesResponse.setter(Builder::inferenceProfileSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceProfileSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InferenceProfileSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInferenceProfilesResponse.getter(ListInferenceProfilesResponse::nextToken)).setter(ListInferenceProfilesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFERENCE_PROFILE_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInferenceProfilesResponse.memberNameToFieldInitializer();
    private final List<InferenceProfileSummary> inferenceProfileSummaries;
    private final String nextToken;

    private ListInferenceProfilesResponse(BuilderImpl builder) {
        super(builder);
        this.inferenceProfileSummaries = builder.inferenceProfileSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInferenceProfileSummaries() {
        return this.inferenceProfileSummaries != null && !(this.inferenceProfileSummaries instanceof SdkAutoConstructList);
    }

    public final List<InferenceProfileSummary> inferenceProfileSummaries() {
        return this.inferenceProfileSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInferenceProfileSummaries() ? this.inferenceProfileSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInferenceProfilesResponse)) {
            return false;
        }
        ListInferenceProfilesResponse other = (ListInferenceProfilesResponse)((Object)obj);
        return this.hasInferenceProfileSummaries() == other.hasInferenceProfileSummaries() && Objects.equals(this.inferenceProfileSummaries(), other.inferenceProfileSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInferenceProfilesResponse").add("InferenceProfileSummaries", this.hasInferenceProfileSummaries() ? this.inferenceProfileSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inferenceProfileSummaries": {
                return Optional.ofNullable(clazz.cast(this.inferenceProfileSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inferenceProfileSummaries", INFERENCE_PROFILE_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInferenceProfilesResponse, T> g) {
        return obj -> g.apply((ListInferenceProfilesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private List<InferenceProfileSummary> inferenceProfileSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInferenceProfilesResponse model) {
            super(model);
            this.inferenceProfileSummaries(model.inferenceProfileSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<InferenceProfileSummary.Builder> getInferenceProfileSummaries() {
            List<InferenceProfileSummary.Builder> result = InferenceProfileSummariesCopier.copyToBuilder(this.inferenceProfileSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInferenceProfileSummaries(Collection<InferenceProfileSummary.BuilderImpl> inferenceProfileSummaries) {
            this.inferenceProfileSummaries = InferenceProfileSummariesCopier.copyFromBuilder(inferenceProfileSummaries);
        }

        @Override
        public final Builder inferenceProfileSummaries(Collection<InferenceProfileSummary> inferenceProfileSummaries) {
            this.inferenceProfileSummaries = InferenceProfileSummariesCopier.copy(inferenceProfileSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceProfileSummaries(InferenceProfileSummary ... inferenceProfileSummaries) {
            this.inferenceProfileSummaries(Arrays.asList(inferenceProfileSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inferenceProfileSummaries(Consumer<InferenceProfileSummary.Builder> ... inferenceProfileSummaries) {
            this.inferenceProfileSummaries(Stream.of(inferenceProfileSummaries).map(c -> (InferenceProfileSummary)((InferenceProfileSummary.Builder)InferenceProfileSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInferenceProfilesResponse build() {
            return new ListInferenceProfilesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInferenceProfilesResponse> {
        public Builder inferenceProfileSummaries(Collection<InferenceProfileSummary> var1);

        public Builder inferenceProfileSummaries(InferenceProfileSummary ... var1);

        public Builder inferenceProfileSummaries(Consumer<InferenceProfileSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

