/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.CustomModelDeploymentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomModelDeploymentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomModelDeploymentSummary> {
    private static final SdkField<String> CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customModelDeploymentArn").getter(CustomModelDeploymentSummary.getter(CustomModelDeploymentSummary::customModelDeploymentArn)).setter(CustomModelDeploymentSummary.setter(Builder::customModelDeploymentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelDeploymentArn").build()}).build();
    private static final SdkField<String> CUSTOM_MODEL_DEPLOYMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("customModelDeploymentName").getter(CustomModelDeploymentSummary.getter(CustomModelDeploymentSummary::customModelDeploymentName)).setter(CustomModelDeploymentSummary.setter(Builder::customModelDeploymentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customModelDeploymentName").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(CustomModelDeploymentSummary.getter(CustomModelDeploymentSummary::modelArn)).setter(CustomModelDeploymentSummary.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CustomModelDeploymentSummary.getter(CustomModelDeploymentSummary::createdAt)).setter(CustomModelDeploymentSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CustomModelDeploymentSummary.getter(CustomModelDeploymentSummary::statusAsString)).setter(CustomModelDeploymentSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(CustomModelDeploymentSummary.getter(CustomModelDeploymentSummary::lastUpdatedAt)).setter(CustomModelDeploymentSummary.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(CustomModelDeploymentSummary.getter(CustomModelDeploymentSummary::failureMessage)).setter(CustomModelDeploymentSummary.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD, CUSTOM_MODEL_DEPLOYMENT_NAME_FIELD, MODEL_ARN_FIELD, CREATED_AT_FIELD, STATUS_FIELD, LAST_UPDATED_AT_FIELD, FAILURE_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomModelDeploymentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String customModelDeploymentArn;
    private final String customModelDeploymentName;
    private final String modelArn;
    private final Instant createdAt;
    private final String status;
    private final Instant lastUpdatedAt;
    private final String failureMessage;

    private CustomModelDeploymentSummary(BuilderImpl builder) {
        this.customModelDeploymentArn = builder.customModelDeploymentArn;
        this.customModelDeploymentName = builder.customModelDeploymentName;
        this.modelArn = builder.modelArn;
        this.createdAt = builder.createdAt;
        this.status = builder.status;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.failureMessage = builder.failureMessage;
    }

    public final String customModelDeploymentArn() {
        return this.customModelDeploymentArn;
    }

    public final String customModelDeploymentName() {
        return this.customModelDeploymentName;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final CustomModelDeploymentStatus status() {
        return CustomModelDeploymentStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelDeploymentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.customModelDeploymentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomModelDeploymentSummary)) {
            return false;
        }
        CustomModelDeploymentSummary other = (CustomModelDeploymentSummary)obj;
        return Objects.equals(this.customModelDeploymentArn(), other.customModelDeploymentArn()) && Objects.equals(this.customModelDeploymentName(), other.customModelDeploymentName()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.failureMessage(), other.failureMessage());
    }

    public final String toString() {
        return ToString.builder((String)"CustomModelDeploymentSummary").add("CustomModelDeploymentArn", (Object)this.customModelDeploymentArn()).add("CustomModelDeploymentName", (Object)this.customModelDeploymentName()).add("ModelArn", (Object)this.modelArn()).add("CreatedAt", (Object)this.createdAt()).add("Status", (Object)this.statusAsString()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("FailureMessage", (Object)this.failureMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customModelDeploymentArn": {
                return Optional.ofNullable(clazz.cast(this.customModelDeploymentArn()));
            }
            case "customModelDeploymentName": {
                return Optional.ofNullable(clazz.cast(this.customModelDeploymentName()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customModelDeploymentArn", CUSTOM_MODEL_DEPLOYMENT_ARN_FIELD);
        map.put("customModelDeploymentName", CUSTOM_MODEL_DEPLOYMENT_NAME_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomModelDeploymentSummary, T> g) {
        return obj -> g.apply((CustomModelDeploymentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String customModelDeploymentArn;
        private String customModelDeploymentName;
        private String modelArn;
        private Instant createdAt;
        private String status;
        private Instant lastUpdatedAt;
        private String failureMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomModelDeploymentSummary model) {
            this.customModelDeploymentArn(model.customModelDeploymentArn);
            this.customModelDeploymentName(model.customModelDeploymentName);
            this.modelArn(model.modelArn);
            this.createdAt(model.createdAt);
            this.status(model.status);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.failureMessage(model.failureMessage);
        }

        public final String getCustomModelDeploymentArn() {
            return this.customModelDeploymentArn;
        }

        public final void setCustomModelDeploymentArn(String customModelDeploymentArn) {
            this.customModelDeploymentArn = customModelDeploymentArn;
        }

        @Override
        public final Builder customModelDeploymentArn(String customModelDeploymentArn) {
            this.customModelDeploymentArn = customModelDeploymentArn;
            return this;
        }

        public final String getCustomModelDeploymentName() {
            return this.customModelDeploymentName;
        }

        public final void setCustomModelDeploymentName(String customModelDeploymentName) {
            this.customModelDeploymentName = customModelDeploymentName;
        }

        @Override
        public final Builder customModelDeploymentName(String customModelDeploymentName) {
            this.customModelDeploymentName = customModelDeploymentName;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CustomModelDeploymentStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public CustomModelDeploymentSummary build() {
            return new CustomModelDeploymentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomModelDeploymentSummary> {
        public Builder customModelDeploymentArn(String var1);

        public Builder customModelDeploymentName(String var1);

        public Builder modelArn(String var1);

        public Builder createdAt(Instant var1);

        public Builder status(String var1);

        public Builder status(CustomModelDeploymentStatus var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder failureMessage(String var1);
    }
}

