/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDefinitionVariableNameListCopier;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyDisjointedRuleIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyDisjointRuleSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyDisjointRuleSet> {
    private static final SdkField<List<String>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(AutomatedReasoningPolicyDisjointRuleSet.getter(AutomatedReasoningPolicyDisjointRuleSet::variables)).setter(AutomatedReasoningPolicyDisjointRuleSet.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(AutomatedReasoningPolicyDisjointRuleSet.getter(AutomatedReasoningPolicyDisjointRuleSet::rules)).setter(AutomatedReasoningPolicyDisjointRuleSet.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD, RULES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyDisjointRuleSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> variables;
    private final List<String> rules;

    private AutomatedReasoningPolicyDisjointRuleSet(BuilderImpl builder) {
        this.variables = builder.variables;
        this.rules = builder.rules;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<String> variables() {
        return this.variables;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<String> rules() {
        return this.rules;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyDisjointRuleSet)) {
            return false;
        }
        AutomatedReasoningPolicyDisjointRuleSet other = (AutomatedReasoningPolicyDisjointRuleSet)obj;
        return this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyDisjointRuleSet").add("Variables", (Object)(this.variables() == null ? null : "*** Sensitive Data Redacted ***")).add("Rules", this.hasRules() ? this.rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("variables", VARIABLES_FIELD);
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyDisjointRuleSet, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyDisjointRuleSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> variables = DefaultSdkAutoConstructList.getInstance();
        private List<String> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyDisjointRuleSet model) {
            this.variables(model.variables);
            this.rules(model.rules);
        }

        public final Collection<String> getVariables() {
            if (this.variables instanceof SdkAutoConstructList) {
                return null;
            }
            return this.variables;
        }

        public final void setVariables(Collection<String> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(variables);
        }

        @Override
        public final Builder variables(Collection<String> variables) {
            this.variables = AutomatedReasoningPolicyDefinitionVariableNameListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(String ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        public final Collection<String> getRules() {
            if (this.rules instanceof SdkAutoConstructList) {
                return null;
            }
            return this.rules;
        }

        public final void setRules(Collection<String> rules) {
            this.rules = AutomatedReasoningPolicyDisjointedRuleIdListCopier.copy(rules);
        }

        @Override
        public final Builder rules(Collection<String> rules) {
            this.rules = AutomatedReasoningPolicyDisjointedRuleIdListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(String ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        public AutomatedReasoningPolicyDisjointRuleSet build() {
            return new AutomatedReasoningPolicyDisjointRuleSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyDisjointRuleSet> {
        public Builder variables(Collection<String> var1);

        public Builder variables(String ... var1);

        public Builder rules(Collection<String> var1);

        public Builder rules(String ... var1);
    }
}

