/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyMutation;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningPolicyPlanning;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningPolicyBuildStepContext
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningPolicyBuildStepContext> {
    private static final SdkField<AutomatedReasoningPolicyPlanning> PLANNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("planning").getter(AutomatedReasoningPolicyBuildStepContext.getter(AutomatedReasoningPolicyBuildStepContext::planning)).setter(AutomatedReasoningPolicyBuildStepContext.setter(Builder::planning)).constructor(AutomatedReasoningPolicyPlanning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planning").build()}).build();
    private static final SdkField<AutomatedReasoningPolicyMutation> MUTATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("mutation").getter(AutomatedReasoningPolicyBuildStepContext.getter(AutomatedReasoningPolicyBuildStepContext::mutation)).setter(AutomatedReasoningPolicyBuildStepContext.setter(Builder::mutation)).constructor(AutomatedReasoningPolicyMutation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mutation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLANNING_FIELD, MUTATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningPolicyBuildStepContext.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningPolicyPlanning planning;
    private final AutomatedReasoningPolicyMutation mutation;
    private final Type type;

    private AutomatedReasoningPolicyBuildStepContext(BuilderImpl builder) {
        this.planning = builder.planning;
        this.mutation = builder.mutation;
        this.type = builder.type;
    }

    public final AutomatedReasoningPolicyPlanning planning() {
        return this.planning;
    }

    public final AutomatedReasoningPolicyMutation mutation() {
        return this.mutation;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.planning());
        hashCode = 31 * hashCode + Objects.hashCode(this.mutation());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningPolicyBuildStepContext)) {
            return false;
        }
        AutomatedReasoningPolicyBuildStepContext other = (AutomatedReasoningPolicyBuildStepContext)obj;
        return Objects.equals(this.planning(), other.planning()) && Objects.equals(this.mutation(), other.mutation());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningPolicyBuildStepContext").add("Planning", (Object)this.planning()).add("Mutation", (Object)this.mutation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planning": {
                return Optional.ofNullable(clazz.cast(this.planning()));
            }
            case "mutation": {
                return Optional.ofNullable(clazz.cast(this.mutation()));
            }
        }
        return Optional.empty();
    }

    public static AutomatedReasoningPolicyBuildStepContext fromPlanning(AutomatedReasoningPolicyPlanning planning) {
        return (AutomatedReasoningPolicyBuildStepContext)AutomatedReasoningPolicyBuildStepContext.builder().planning(planning).build();
    }

    public static AutomatedReasoningPolicyBuildStepContext fromPlanning(Consumer<AutomatedReasoningPolicyPlanning.Builder> planning) {
        AutomatedReasoningPolicyPlanning.Builder builder = AutomatedReasoningPolicyPlanning.builder();
        planning.accept(builder);
        return AutomatedReasoningPolicyBuildStepContext.fromPlanning((AutomatedReasoningPolicyPlanning)builder.build());
    }

    public static AutomatedReasoningPolicyBuildStepContext fromMutation(AutomatedReasoningPolicyMutation mutation) {
        return (AutomatedReasoningPolicyBuildStepContext)AutomatedReasoningPolicyBuildStepContext.builder().mutation(mutation).build();
    }

    public static AutomatedReasoningPolicyBuildStepContext fromMutation(Consumer<AutomatedReasoningPolicyMutation.Builder> mutation) {
        AutomatedReasoningPolicyMutation.Builder builder = AutomatedReasoningPolicyMutation.builder();
        mutation.accept(builder);
        return AutomatedReasoningPolicyBuildStepContext.fromMutation((AutomatedReasoningPolicyMutation)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("planning", PLANNING_FIELD);
        map.put("mutation", MUTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningPolicyBuildStepContext, T> g) {
        return obj -> g.apply((AutomatedReasoningPolicyBuildStepContext)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        PLANNING,
        MUTATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningPolicyPlanning planning;
        private AutomatedReasoningPolicyMutation mutation;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningPolicyBuildStepContext model) {
            this.planning(model.planning);
            this.mutation(model.mutation);
        }

        public final AutomatedReasoningPolicyPlanning.Builder getPlanning() {
            return this.planning != null ? this.planning.toBuilder() : null;
        }

        public final void setPlanning(AutomatedReasoningPolicyPlanning.BuilderImpl planning) {
            AutomatedReasoningPolicyPlanning oldValue = this.planning;
            this.planning = planning != null ? planning.build() : null;
            this.handleUnionValueChange(Type.PLANNING, oldValue, this.planning);
        }

        @Override
        public final Builder planning(AutomatedReasoningPolicyPlanning planning) {
            AutomatedReasoningPolicyPlanning oldValue = this.planning;
            this.planning = planning;
            this.handleUnionValueChange(Type.PLANNING, oldValue, this.planning);
            return this;
        }

        public final AutomatedReasoningPolicyMutation.Builder getMutation() {
            return this.mutation != null ? this.mutation.toBuilder() : null;
        }

        public final void setMutation(AutomatedReasoningPolicyMutation.BuilderImpl mutation) {
            AutomatedReasoningPolicyMutation oldValue = this.mutation;
            this.mutation = mutation != null ? mutation.build() : null;
            this.handleUnionValueChange(Type.MUTATION, oldValue, this.mutation);
        }

        @Override
        public final Builder mutation(AutomatedReasoningPolicyMutation mutation) {
            AutomatedReasoningPolicyMutation oldValue = this.mutation;
            this.mutation = mutation;
            this.handleUnionValueChange(Type.MUTATION, oldValue, this.mutation);
            return this;
        }

        public AutomatedReasoningPolicyBuildStepContext build() {
            return new AutomatedReasoningPolicyBuildStepContext(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningPolicyBuildStepContext> {
        public Builder planning(AutomatedReasoningPolicyPlanning var1);

        default public Builder planning(Consumer<AutomatedReasoningPolicyPlanning.Builder> planning) {
            return this.planning((AutomatedReasoningPolicyPlanning)((AutomatedReasoningPolicyPlanning.Builder)AutomatedReasoningPolicyPlanning.builder().applyMutation(planning)).build());
        }

        public Builder mutation(AutomatedReasoningPolicyMutation var1);

        default public Builder mutation(Consumer<AutomatedReasoningPolicyMutation.Builder> mutation) {
            return this.mutation((AutomatedReasoningPolicyMutation)((AutomatedReasoningPolicyMutation.Builder)AutomatedReasoningPolicyMutation.builder().applyMutation(mutation)).build());
        }
    }
}

