/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckLogicWarning;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckScenario;
import software.amazon.awssdk.services.bedrock.model.AutomatedReasoningCheckTranslation;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutomatedReasoningCheckSatisfiableFinding
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutomatedReasoningCheckSatisfiableFinding> {
    private static final SdkField<AutomatedReasoningCheckTranslation> TRANSLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("translation").getter(AutomatedReasoningCheckSatisfiableFinding.getter(AutomatedReasoningCheckSatisfiableFinding::translation)).setter(AutomatedReasoningCheckSatisfiableFinding.setter(Builder::translation)).constructor(AutomatedReasoningCheckTranslation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()}).build();
    private static final SdkField<AutomatedReasoningCheckScenario> CLAIMS_TRUE_SCENARIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("claimsTrueScenario").getter(AutomatedReasoningCheckSatisfiableFinding.getter(AutomatedReasoningCheckSatisfiableFinding::claimsTrueScenario)).setter(AutomatedReasoningCheckSatisfiableFinding.setter(Builder::claimsTrueScenario)).constructor(AutomatedReasoningCheckScenario::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsTrueScenario").build()}).build();
    private static final SdkField<AutomatedReasoningCheckScenario> CLAIMS_FALSE_SCENARIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("claimsFalseScenario").getter(AutomatedReasoningCheckSatisfiableFinding.getter(AutomatedReasoningCheckSatisfiableFinding::claimsFalseScenario)).setter(AutomatedReasoningCheckSatisfiableFinding.setter(Builder::claimsFalseScenario)).constructor(AutomatedReasoningCheckScenario::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsFalseScenario").build()}).build();
    private static final SdkField<AutomatedReasoningCheckLogicWarning> LOGIC_WARNING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logicWarning").getter(AutomatedReasoningCheckSatisfiableFinding.getter(AutomatedReasoningCheckSatisfiableFinding::logicWarning)).setter(AutomatedReasoningCheckSatisfiableFinding.setter(Builder::logicWarning)).constructor(AutomatedReasoningCheckLogicWarning::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD, CLAIMS_TRUE_SCENARIO_FIELD, CLAIMS_FALSE_SCENARIO_FIELD, LOGIC_WARNING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AutomatedReasoningCheckSatisfiableFinding.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AutomatedReasoningCheckTranslation translation;
    private final AutomatedReasoningCheckScenario claimsTrueScenario;
    private final AutomatedReasoningCheckScenario claimsFalseScenario;
    private final AutomatedReasoningCheckLogicWarning logicWarning;

    private AutomatedReasoningCheckSatisfiableFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.claimsTrueScenario = builder.claimsTrueScenario;
        this.claimsFalseScenario = builder.claimsFalseScenario;
        this.logicWarning = builder.logicWarning;
    }

    public final AutomatedReasoningCheckTranslation translation() {
        return this.translation;
    }

    public final AutomatedReasoningCheckScenario claimsTrueScenario() {
        return this.claimsTrueScenario;
    }

    public final AutomatedReasoningCheckScenario claimsFalseScenario() {
        return this.claimsFalseScenario;
    }

    public final AutomatedReasoningCheckLogicWarning logicWarning() {
        return this.logicWarning;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.translation());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimsTrueScenario());
        hashCode = 31 * hashCode + Objects.hashCode(this.claimsFalseScenario());
        hashCode = 31 * hashCode + Objects.hashCode(this.logicWarning());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutomatedReasoningCheckSatisfiableFinding)) {
            return false;
        }
        AutomatedReasoningCheckSatisfiableFinding other = (AutomatedReasoningCheckSatisfiableFinding)obj;
        return Objects.equals(this.translation(), other.translation()) && Objects.equals(this.claimsTrueScenario(), other.claimsTrueScenario()) && Objects.equals(this.claimsFalseScenario(), other.claimsFalseScenario()) && Objects.equals(this.logicWarning(), other.logicWarning());
    }

    public final String toString() {
        return ToString.builder((String)"AutomatedReasoningCheckSatisfiableFinding").add("Translation", (Object)this.translation()).add("ClaimsTrueScenario", (Object)this.claimsTrueScenario()).add("ClaimsFalseScenario", (Object)this.claimsFalseScenario()).add("LogicWarning", (Object)this.logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "translation": {
                return Optional.ofNullable(clazz.cast(this.translation()));
            }
            case "claimsTrueScenario": {
                return Optional.ofNullable(clazz.cast(this.claimsTrueScenario()));
            }
            case "claimsFalseScenario": {
                return Optional.ofNullable(clazz.cast(this.claimsFalseScenario()));
            }
            case "logicWarning": {
                return Optional.ofNullable(clazz.cast(this.logicWarning()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("claimsTrueScenario", CLAIMS_TRUE_SCENARIO_FIELD);
        map.put("claimsFalseScenario", CLAIMS_FALSE_SCENARIO_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AutomatedReasoningCheckSatisfiableFinding, T> g) {
        return obj -> g.apply((AutomatedReasoningCheckSatisfiableFinding)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AutomatedReasoningCheckTranslation translation;
        private AutomatedReasoningCheckScenario claimsTrueScenario;
        private AutomatedReasoningCheckScenario claimsFalseScenario;
        private AutomatedReasoningCheckLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(AutomatedReasoningCheckSatisfiableFinding model) {
            this.translation(model.translation);
            this.claimsTrueScenario(model.claimsTrueScenario);
            this.claimsFalseScenario(model.claimsFalseScenario);
            this.logicWarning(model.logicWarning);
        }

        public final AutomatedReasoningCheckTranslation.Builder getTranslation() {
            return this.translation != null ? this.translation.toBuilder() : null;
        }

        public final void setTranslation(AutomatedReasoningCheckTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(AutomatedReasoningCheckTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final AutomatedReasoningCheckScenario.Builder getClaimsTrueScenario() {
            return this.claimsTrueScenario != null ? this.claimsTrueScenario.toBuilder() : null;
        }

        public final void setClaimsTrueScenario(AutomatedReasoningCheckScenario.BuilderImpl claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario != null ? claimsTrueScenario.build() : null;
        }

        @Override
        public final Builder claimsTrueScenario(AutomatedReasoningCheckScenario claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario;
            return this;
        }

        public final AutomatedReasoningCheckScenario.Builder getClaimsFalseScenario() {
            return this.claimsFalseScenario != null ? this.claimsFalseScenario.toBuilder() : null;
        }

        public final void setClaimsFalseScenario(AutomatedReasoningCheckScenario.BuilderImpl claimsFalseScenario) {
            this.claimsFalseScenario = claimsFalseScenario != null ? claimsFalseScenario.build() : null;
        }

        @Override
        public final Builder claimsFalseScenario(AutomatedReasoningCheckScenario claimsFalseScenario) {
            this.claimsFalseScenario = claimsFalseScenario;
            return this;
        }

        public final AutomatedReasoningCheckLogicWarning.Builder getLogicWarning() {
            return this.logicWarning != null ? this.logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(AutomatedReasoningCheckLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(AutomatedReasoningCheckLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        public AutomatedReasoningCheckSatisfiableFinding build() {
            return new AutomatedReasoningCheckSatisfiableFinding(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutomatedReasoningCheckSatisfiableFinding> {
        public Builder translation(AutomatedReasoningCheckTranslation var1);

        default public Builder translation(Consumer<AutomatedReasoningCheckTranslation.Builder> translation) {
            return this.translation((AutomatedReasoningCheckTranslation)((AutomatedReasoningCheckTranslation.Builder)AutomatedReasoningCheckTranslation.builder().applyMutation(translation)).build());
        }

        public Builder claimsTrueScenario(AutomatedReasoningCheckScenario var1);

        default public Builder claimsTrueScenario(Consumer<AutomatedReasoningCheckScenario.Builder> claimsTrueScenario) {
            return this.claimsTrueScenario((AutomatedReasoningCheckScenario)((AutomatedReasoningCheckScenario.Builder)AutomatedReasoningCheckScenario.builder().applyMutation(claimsTrueScenario)).build());
        }

        public Builder claimsFalseScenario(AutomatedReasoningCheckScenario var1);

        default public Builder claimsFalseScenario(Consumer<AutomatedReasoningCheckScenario.Builder> claimsFalseScenario) {
            return this.claimsFalseScenario((AutomatedReasoningCheckScenario)((AutomatedReasoningCheckScenario.Builder)AutomatedReasoningCheckScenario.builder().applyMutation(claimsFalseScenario)).build());
        }

        public Builder logicWarning(AutomatedReasoningCheckLogicWarning var1);

        default public Builder logicWarning(Consumer<AutomatedReasoningCheckLogicWarning.Builder> logicWarning) {
            return this.logicWarning((AutomatedReasoningCheckLogicWarning)((AutomatedReasoningCheckLogicWarning.Builder)AutomatedReasoningCheckLogicWarning.builder().applyMutation(logicWarning)).build());
        }
    }
}

