/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.CustomModelSummary;
import software.amazon.awssdk.services.bedrock.model.CustomModelSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCustomModelsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListCustomModelsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCustomModelsResponse.getter(ListCustomModelsResponse::nextToken)).setter(ListCustomModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CustomModelSummary>> MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelSummaries").getter(ListCustomModelsResponse.getter(ListCustomModelsResponse::modelSummaries)).setter(ListCustomModelsResponse.setter(Builder::modelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODEL_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListCustomModelsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<CustomModelSummary> modelSummaries;

    private ListCustomModelsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelSummaries = builder.modelSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModelSummaries() {
        return this.modelSummaries != null && !(this.modelSummaries instanceof SdkAutoConstructList);
    }

    public final List<CustomModelSummary> modelSummaries() {
        return this.modelSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelSummaries() ? this.modelSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCustomModelsResponse)) {
            return false;
        }
        ListCustomModelsResponse other = (ListCustomModelsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModelSummaries() == other.hasModelSummaries() && Objects.equals(this.modelSummaries(), other.modelSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListCustomModelsResponse").add("NextToken", (Object)this.nextToken()).add("ModelSummaries", this.hasModelSummaries() ? this.modelSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "modelSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("modelSummaries", MODEL_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCustomModelsResponse, T> g) {
        return obj -> g.apply((ListCustomModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CustomModelSummary> modelSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCustomModelsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.modelSummaries(model.modelSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CustomModelSummary.Builder> getModelSummaries() {
            List<CustomModelSummary.Builder> result = CustomModelSummaryListCopier.copyToBuilder(this.modelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelSummaries(Collection<CustomModelSummary.BuilderImpl> modelSummaries) {
            this.modelSummaries = CustomModelSummaryListCopier.copyFromBuilder(modelSummaries);
        }

        @Override
        public final Builder modelSummaries(Collection<CustomModelSummary> modelSummaries) {
            this.modelSummaries = CustomModelSummaryListCopier.copy(modelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(CustomModelSummary ... modelSummaries) {
            this.modelSummaries(Arrays.asList(modelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelSummaries(Consumer<CustomModelSummary.Builder> ... modelSummaries) {
            this.modelSummaries(Stream.of(modelSummaries).map(c -> (CustomModelSummary)((CustomModelSummary.Builder)CustomModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListCustomModelsResponse build() {
            return new ListCustomModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCustomModelsResponse> {
        public Builder nextToken(String var1);

        public Builder modelSummaries(Collection<CustomModelSummary> var1);

        public Builder modelSummaries(CustomModelSummary ... var1);

        public Builder modelSummaries(Consumer<CustomModelSummary.Builder> ... var1);
    }
}

