/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelImportJobSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.ModelImportJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelImportJobsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListModelImportJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListModelImportJobsResponse.getter(ListModelImportJobsResponse::nextToken)).setter(ListModelImportJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ModelImportJobSummary>> MODEL_IMPORT_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("modelImportJobSummaries").getter(ListModelImportJobsResponse.getter(ListModelImportJobsResponse::modelImportJobSummaries)).setter(ListModelImportJobsResponse.setter(Builder::modelImportJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelImportJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelImportJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, MODEL_IMPORT_JOB_SUMMARIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListModelImportJobsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<ModelImportJobSummary> modelImportJobSummaries;

    private ListModelImportJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.modelImportJobSummaries = builder.modelImportJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasModelImportJobSummaries() {
        return this.modelImportJobSummaries != null && !(this.modelImportJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelImportJobSummary> modelImportJobSummaries() {
        return this.modelImportJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasModelImportJobSummaries() ? this.modelImportJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelImportJobsResponse)) {
            return false;
        }
        ListModelImportJobsResponse other = (ListModelImportJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasModelImportJobSummaries() == other.hasModelImportJobSummaries() && Objects.equals(this.modelImportJobSummaries(), other.modelImportJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelImportJobsResponse").add("NextToken", (Object)this.nextToken()).add("ModelImportJobSummaries", this.hasModelImportJobSummaries() ? this.modelImportJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "modelImportJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.modelImportJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("modelImportJobSummaries", MODEL_IMPORT_JOB_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListModelImportJobsResponse, T> g) {
        return obj -> g.apply((ListModelImportJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ModelImportJobSummary> modelImportJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelImportJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.modelImportJobSummaries(model.modelImportJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelImportJobSummary.Builder> getModelImportJobSummaries() {
            List<ModelImportJobSummary.Builder> result = ModelImportJobSummariesCopier.copyToBuilder(this.modelImportJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setModelImportJobSummaries(Collection<ModelImportJobSummary.BuilderImpl> modelImportJobSummaries) {
            this.modelImportJobSummaries = ModelImportJobSummariesCopier.copyFromBuilder(modelImportJobSummaries);
        }

        @Override
        public final Builder modelImportJobSummaries(Collection<ModelImportJobSummary> modelImportJobSummaries) {
            this.modelImportJobSummaries = ModelImportJobSummariesCopier.copy(modelImportJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelImportJobSummaries(ModelImportJobSummary ... modelImportJobSummaries) {
            this.modelImportJobSummaries(Arrays.asList(modelImportJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder modelImportJobSummaries(Consumer<ModelImportJobSummary.Builder> ... modelImportJobSummaries) {
            this.modelImportJobSummaries(Stream.of(modelImportJobSummaries).map(c -> (ModelImportJobSummary)((ModelImportJobSummary.Builder)ModelImportJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelImportJobsResponse build() {
            return new ListModelImportJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelImportJobsResponse> {
        public Builder nextToken(String var1);

        public Builder modelImportJobSummaries(Collection<ModelImportJobSummary> var1);

        public Builder modelImportJobSummaries(ModelImportJobSummary ... var1);

        public Builder modelImportJobSummaries(Consumer<ModelImportJobSummary.Builder> ... var1);
    }
}

