/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrock.model.GenerationConfiguration;
import software.amazon.awssdk.services.bedrock.model.KnowledgeBaseRetrievalConfiguration;
import software.amazon.awssdk.services.bedrock.model.OrchestrationConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseRetrieveAndGenerateConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
    private static final SdkField<String> KNOWLEDGE_BASE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("knowledgeBaseId").getter(KnowledgeBaseRetrieveAndGenerateConfiguration.getter(KnowledgeBaseRetrieveAndGenerateConfiguration::knowledgeBaseId)).setter(KnowledgeBaseRetrieveAndGenerateConfiguration.setter(Builder::knowledgeBaseId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseId").build()}).build();
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelArn").getter(KnowledgeBaseRetrieveAndGenerateConfiguration.getter(KnowledgeBaseRetrieveAndGenerateConfiguration::modelArn)).setter(KnowledgeBaseRetrieveAndGenerateConfiguration.setter(Builder::modelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()}).build();
    private static final SdkField<KnowledgeBaseRetrievalConfiguration> RETRIEVAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("retrievalConfiguration").getter(KnowledgeBaseRetrieveAndGenerateConfiguration.getter(KnowledgeBaseRetrieveAndGenerateConfiguration::retrievalConfiguration)).setter(KnowledgeBaseRetrieveAndGenerateConfiguration.setter(Builder::retrievalConfiguration)).constructor(KnowledgeBaseRetrievalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalConfiguration").build()}).build();
    private static final SdkField<GenerationConfiguration> GENERATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generationConfiguration").getter(KnowledgeBaseRetrieveAndGenerateConfiguration.getter(KnowledgeBaseRetrieveAndGenerateConfiguration::generationConfiguration)).setter(KnowledgeBaseRetrieveAndGenerateConfiguration.setter(Builder::generationConfiguration)).constructor(GenerationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generationConfiguration").build()}).build();
    private static final SdkField<OrchestrationConfiguration> ORCHESTRATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("orchestrationConfiguration").getter(KnowledgeBaseRetrieveAndGenerateConfiguration.getter(KnowledgeBaseRetrieveAndGenerateConfiguration::orchestrationConfiguration)).setter(KnowledgeBaseRetrieveAndGenerateConfiguration.setter(Builder::orchestrationConfiguration)).constructor(OrchestrationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrationConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KNOWLEDGE_BASE_ID_FIELD, MODEL_ARN_FIELD, RETRIEVAL_CONFIGURATION_FIELD, GENERATION_CONFIGURATION_FIELD, ORCHESTRATION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseRetrieveAndGenerateConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String knowledgeBaseId;
    private final String modelArn;
    private final KnowledgeBaseRetrievalConfiguration retrievalConfiguration;
    private final GenerationConfiguration generationConfiguration;
    private final OrchestrationConfiguration orchestrationConfiguration;

    private KnowledgeBaseRetrieveAndGenerateConfiguration(BuilderImpl builder) {
        this.knowledgeBaseId = builder.knowledgeBaseId;
        this.modelArn = builder.modelArn;
        this.retrievalConfiguration = builder.retrievalConfiguration;
        this.generationConfiguration = builder.generationConfiguration;
        this.orchestrationConfiguration = builder.orchestrationConfiguration;
    }

    public final String knowledgeBaseId() {
        return this.knowledgeBaseId;
    }

    public final String modelArn() {
        return this.modelArn;
    }

    public final KnowledgeBaseRetrievalConfiguration retrievalConfiguration() {
        return this.retrievalConfiguration;
    }

    public final GenerationConfiguration generationConfiguration() {
        return this.generationConfiguration;
    }

    public final OrchestrationConfiguration orchestrationConfiguration() {
        return this.orchestrationConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseId());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.retrievalConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.generationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestrationConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseRetrieveAndGenerateConfiguration)) {
            return false;
        }
        KnowledgeBaseRetrieveAndGenerateConfiguration other = (KnowledgeBaseRetrieveAndGenerateConfiguration)obj;
        return Objects.equals(this.knowledgeBaseId(), other.knowledgeBaseId()) && Objects.equals(this.modelArn(), other.modelArn()) && Objects.equals(this.retrievalConfiguration(), other.retrievalConfiguration()) && Objects.equals(this.generationConfiguration(), other.generationConfiguration()) && Objects.equals(this.orchestrationConfiguration(), other.orchestrationConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseRetrieveAndGenerateConfiguration").add("KnowledgeBaseId", (Object)this.knowledgeBaseId()).add("ModelArn", (Object)this.modelArn()).add("RetrievalConfiguration", (Object)this.retrievalConfiguration()).add("GenerationConfiguration", (Object)this.generationConfiguration()).add("OrchestrationConfiguration", (Object)this.orchestrationConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "knowledgeBaseId": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseId()));
            }
            case "modelArn": {
                return Optional.ofNullable(clazz.cast(this.modelArn()));
            }
            case "retrievalConfiguration": {
                return Optional.ofNullable(clazz.cast(this.retrievalConfiguration()));
            }
            case "generationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.generationConfiguration()));
            }
            case "orchestrationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.orchestrationConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("knowledgeBaseId", KNOWLEDGE_BASE_ID_FIELD);
        map.put("modelArn", MODEL_ARN_FIELD);
        map.put("retrievalConfiguration", RETRIEVAL_CONFIGURATION_FIELD);
        map.put("generationConfiguration", GENERATION_CONFIGURATION_FIELD);
        map.put("orchestrationConfiguration", ORCHESTRATION_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseRetrieveAndGenerateConfiguration, T> g) {
        return obj -> g.apply((KnowledgeBaseRetrieveAndGenerateConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String knowledgeBaseId;
        private String modelArn;
        private KnowledgeBaseRetrievalConfiguration retrievalConfiguration;
        private GenerationConfiguration generationConfiguration;
        private OrchestrationConfiguration orchestrationConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseRetrieveAndGenerateConfiguration model) {
            this.knowledgeBaseId(model.knowledgeBaseId);
            this.modelArn(model.modelArn);
            this.retrievalConfiguration(model.retrievalConfiguration);
            this.generationConfiguration(model.generationConfiguration);
            this.orchestrationConfiguration(model.orchestrationConfiguration);
        }

        public final String getKnowledgeBaseId() {
            return this.knowledgeBaseId;
        }

        public final void setKnowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
        }

        @Override
        public final Builder knowledgeBaseId(String knowledgeBaseId) {
            this.knowledgeBaseId = knowledgeBaseId;
            return this;
        }

        public final String getModelArn() {
            return this.modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final KnowledgeBaseRetrievalConfiguration.Builder getRetrievalConfiguration() {
            return this.retrievalConfiguration != null ? this.retrievalConfiguration.toBuilder() : null;
        }

        public final void setRetrievalConfiguration(KnowledgeBaseRetrievalConfiguration.BuilderImpl retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration != null ? retrievalConfiguration.build() : null;
        }

        @Override
        public final Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration retrievalConfiguration) {
            this.retrievalConfiguration = retrievalConfiguration;
            return this;
        }

        public final GenerationConfiguration.Builder getGenerationConfiguration() {
            return this.generationConfiguration != null ? this.generationConfiguration.toBuilder() : null;
        }

        public final void setGenerationConfiguration(GenerationConfiguration.BuilderImpl generationConfiguration) {
            this.generationConfiguration = generationConfiguration != null ? generationConfiguration.build() : null;
        }

        @Override
        public final Builder generationConfiguration(GenerationConfiguration generationConfiguration) {
            this.generationConfiguration = generationConfiguration;
            return this;
        }

        public final OrchestrationConfiguration.Builder getOrchestrationConfiguration() {
            return this.orchestrationConfiguration != null ? this.orchestrationConfiguration.toBuilder() : null;
        }

        public final void setOrchestrationConfiguration(OrchestrationConfiguration.BuilderImpl orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration != null ? orchestrationConfiguration.build() : null;
        }

        @Override
        public final Builder orchestrationConfiguration(OrchestrationConfiguration orchestrationConfiguration) {
            this.orchestrationConfiguration = orchestrationConfiguration;
            return this;
        }

        public KnowledgeBaseRetrieveAndGenerateConfiguration build() {
            return new KnowledgeBaseRetrieveAndGenerateConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseRetrieveAndGenerateConfiguration> {
        public Builder knowledgeBaseId(String var1);

        public Builder modelArn(String var1);

        public Builder retrievalConfiguration(KnowledgeBaseRetrievalConfiguration var1);

        default public Builder retrievalConfiguration(Consumer<KnowledgeBaseRetrievalConfiguration.Builder> retrievalConfiguration) {
            return this.retrievalConfiguration((KnowledgeBaseRetrievalConfiguration)((KnowledgeBaseRetrievalConfiguration.Builder)KnowledgeBaseRetrievalConfiguration.builder().applyMutation(retrievalConfiguration)).build());
        }

        public Builder generationConfiguration(GenerationConfiguration var1);

        default public Builder generationConfiguration(Consumer<GenerationConfiguration.Builder> generationConfiguration) {
            return this.generationConfiguration((GenerationConfiguration)((GenerationConfiguration.Builder)GenerationConfiguration.builder().applyMutation(generationConfiguration)).build());
        }

        public Builder orchestrationConfiguration(OrchestrationConfiguration var1);

        default public Builder orchestrationConfiguration(Consumer<OrchestrationConfiguration.Builder> orchestrationConfiguration) {
            return this.orchestrationConfiguration((OrchestrationConfiguration)((OrchestrationConfiguration.Builder)OrchestrationConfiguration.builder().applyMutation(orchestrationConfiguration)).build());
        }
    }
}

