/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopic;
import software.amazon.awssdk.services.bedrock.model.GuardrailTopicsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailTopicPolicy
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailTopicPolicy> {
    private static final SdkField<List<GuardrailTopic>> TOPICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("topics").getter(GuardrailTopicPolicy.getter(GuardrailTopicPolicy::topics)).setter(GuardrailTopicPolicy.setter(Builder::topics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topics").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailTopic::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailTopicPolicy.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<GuardrailTopic> topics;

    private GuardrailTopicPolicy(BuilderImpl builder) {
        this.topics = builder.topics;
    }

    public final boolean hasTopics() {
        return this.topics != null && !(this.topics instanceof SdkAutoConstructList);
    }

    public final List<GuardrailTopic> topics() {
        return this.topics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTopics() ? this.topics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailTopicPolicy)) {
            return false;
        }
        GuardrailTopicPolicy other = (GuardrailTopicPolicy)obj;
        return this.hasTopics() == other.hasTopics() && Objects.equals(this.topics(), other.topics());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailTopicPolicy").add("Topics", this.hasTopics() ? this.topics() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "topics": {
                return Optional.ofNullable(clazz.cast(this.topics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<GuardrailTopic>>> map = new HashMap<String, SdkField<List<GuardrailTopic>>>();
        map.put("topics", TOPICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailTopicPolicy, T> g) {
        return obj -> g.apply((GuardrailTopicPolicy)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailTopic> topics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailTopicPolicy model) {
            this.topics(model.topics);
        }

        public final List<GuardrailTopic.Builder> getTopics() {
            List<GuardrailTopic.Builder> result = GuardrailTopicsCopier.copyToBuilder(this.topics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTopics(Collection<GuardrailTopic.BuilderImpl> topics) {
            this.topics = GuardrailTopicsCopier.copyFromBuilder(topics);
        }

        @Override
        public final Builder topics(Collection<GuardrailTopic> topics) {
            this.topics = GuardrailTopicsCopier.copy(topics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(GuardrailTopic ... topics) {
            this.topics(Arrays.asList(topics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder topics(Consumer<GuardrailTopic.Builder> ... topics) {
            this.topics(Stream.of(topics).map(c -> (GuardrailTopic)((GuardrailTopic.Builder)GuardrailTopic.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GuardrailTopicPolicy build() {
            return new GuardrailTopicPolicy(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailTopicPolicy> {
        public Builder topics(Collection<GuardrailTopic> var1);

        public Builder topics(GuardrailTopic ... var1);

        public Builder topics(Consumer<GuardrailTopic.Builder> ... var1);
    }
}

