/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.GuardrailContentFilterType;
import software.amazon.awssdk.services.bedrock.model.GuardrailFilterStrength;
import software.amazon.awssdk.services.bedrock.model.GuardrailModalitiesCopier;
import software.amazon.awssdk.services.bedrock.model.GuardrailModality;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailContentFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailContentFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GuardrailContentFilter.getter(GuardrailContentFilter::typeAsString)).setter(GuardrailContentFilter.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> INPUT_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("inputStrength").getter(GuardrailContentFilter.getter(GuardrailContentFilter::inputStrengthAsString)).setter(GuardrailContentFilter.setter(Builder::inputStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputStrength").build()}).build();
    private static final SdkField<String> OUTPUT_STRENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("outputStrength").getter(GuardrailContentFilter.getter(GuardrailContentFilter::outputStrengthAsString)).setter(GuardrailContentFilter.setter(Builder::outputStrength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputStrength").build()}).build();
    private static final SdkField<List<String>> INPUT_MODALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputModalities").getter(GuardrailContentFilter.getter(GuardrailContentFilter::inputModalitiesAsStrings)).setter(GuardrailContentFilter.setter(Builder::inputModalitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputModalities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> OUTPUT_MODALITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputModalities").getter(GuardrailContentFilter.getter(GuardrailContentFilter::outputModalitiesAsStrings)).setter(GuardrailContentFilter.setter(Builder::outputModalitiesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputModalities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, INPUT_STRENGTH_FIELD, OUTPUT_STRENGTH_FIELD, INPUT_MODALITIES_FIELD, OUTPUT_MODALITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GuardrailContentFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String inputStrength;
    private final String outputStrength;
    private final List<String> inputModalities;
    private final List<String> outputModalities;

    private GuardrailContentFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.inputStrength = builder.inputStrength;
        this.outputStrength = builder.outputStrength;
        this.inputModalities = builder.inputModalities;
        this.outputModalities = builder.outputModalities;
    }

    public final GuardrailContentFilterType type() {
        return GuardrailContentFilterType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final GuardrailFilterStrength inputStrength() {
        return GuardrailFilterStrength.fromValue(this.inputStrength);
    }

    public final String inputStrengthAsString() {
        return this.inputStrength;
    }

    public final GuardrailFilterStrength outputStrength() {
        return GuardrailFilterStrength.fromValue(this.outputStrength);
    }

    public final String outputStrengthAsString() {
        return this.outputStrength;
    }

    public final List<GuardrailModality> inputModalities() {
        return GuardrailModalitiesCopier.copyStringToEnum(this.inputModalities);
    }

    public final boolean hasInputModalities() {
        return this.inputModalities != null && !(this.inputModalities instanceof SdkAutoConstructList);
    }

    public final List<String> inputModalitiesAsStrings() {
        return this.inputModalities;
    }

    public final List<GuardrailModality> outputModalities() {
        return GuardrailModalitiesCopier.copyStringToEnum(this.outputModalities);
    }

    public final boolean hasOutputModalities() {
        return this.outputModalities != null && !(this.outputModalities instanceof SdkAutoConstructList);
    }

    public final List<String> outputModalitiesAsStrings() {
        return this.outputModalities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputStrengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputStrengthAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputModalities() ? this.inputModalitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputModalities() ? this.outputModalitiesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContentFilter)) {
            return false;
        }
        GuardrailContentFilter other = (GuardrailContentFilter)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.inputStrengthAsString(), other.inputStrengthAsString()) && Objects.equals(this.outputStrengthAsString(), other.outputStrengthAsString()) && this.hasInputModalities() == other.hasInputModalities() && Objects.equals(this.inputModalitiesAsStrings(), other.inputModalitiesAsStrings()) && this.hasOutputModalities() == other.hasOutputModalities() && Objects.equals(this.outputModalitiesAsStrings(), other.outputModalitiesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailContentFilter").add("Type", (Object)this.typeAsString()).add("InputStrength", (Object)this.inputStrengthAsString()).add("OutputStrength", (Object)this.outputStrengthAsString()).add("InputModalities", (Object)(this.inputModalitiesAsStrings() == null ? null : "*** Sensitive Data Redacted ***")).add("OutputModalities", (Object)(this.outputModalitiesAsStrings() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "inputStrength": {
                return Optional.ofNullable(clazz.cast(this.inputStrengthAsString()));
            }
            case "outputStrength": {
                return Optional.ofNullable(clazz.cast(this.outputStrengthAsString()));
            }
            case "inputModalities": {
                return Optional.ofNullable(clazz.cast(this.inputModalitiesAsStrings()));
            }
            case "outputModalities": {
                return Optional.ofNullable(clazz.cast(this.outputModalitiesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("inputStrength", INPUT_STRENGTH_FIELD);
        map.put("outputStrength", OUTPUT_STRENGTH_FIELD);
        map.put("inputModalities", INPUT_MODALITIES_FIELD);
        map.put("outputModalities", OUTPUT_MODALITIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContentFilter, T> g) {
        return obj -> g.apply((GuardrailContentFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String inputStrength;
        private String outputStrength;
        private List<String> inputModalities = DefaultSdkAutoConstructList.getInstance();
        private List<String> outputModalities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContentFilter model) {
            this.type(model.type);
            this.inputStrength(model.inputStrength);
            this.outputStrength(model.outputStrength);
            this.inputModalitiesWithStrings(model.inputModalities);
            this.outputModalitiesWithStrings(model.outputModalities);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContentFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getInputStrength() {
            return this.inputStrength;
        }

        public final void setInputStrength(String inputStrength) {
            this.inputStrength = inputStrength;
        }

        @Override
        public final Builder inputStrength(String inputStrength) {
            this.inputStrength = inputStrength;
            return this;
        }

        @Override
        public final Builder inputStrength(GuardrailFilterStrength inputStrength) {
            this.inputStrength(inputStrength == null ? null : inputStrength.toString());
            return this;
        }

        public final String getOutputStrength() {
            return this.outputStrength;
        }

        public final void setOutputStrength(String outputStrength) {
            this.outputStrength = outputStrength;
        }

        @Override
        public final Builder outputStrength(String outputStrength) {
            this.outputStrength = outputStrength;
            return this;
        }

        @Override
        public final Builder outputStrength(GuardrailFilterStrength outputStrength) {
            this.outputStrength(outputStrength == null ? null : outputStrength.toString());
            return this;
        }

        public final Collection<String> getInputModalities() {
            if (this.inputModalities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputModalities;
        }

        public final void setInputModalities(Collection<String> inputModalities) {
            this.inputModalities = GuardrailModalitiesCopier.copy(inputModalities);
        }

        @Override
        public final Builder inputModalitiesWithStrings(Collection<String> inputModalities) {
            this.inputModalities = GuardrailModalitiesCopier.copy(inputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputModalitiesWithStrings(String ... inputModalities) {
            this.inputModalitiesWithStrings(Arrays.asList(inputModalities));
            return this;
        }

        @Override
        public final Builder inputModalities(Collection<GuardrailModality> inputModalities) {
            this.inputModalities = GuardrailModalitiesCopier.copyEnumToString(inputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputModalities(GuardrailModality ... inputModalities) {
            this.inputModalities(Arrays.asList(inputModalities));
            return this;
        }

        public final Collection<String> getOutputModalities() {
            if (this.outputModalities instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outputModalities;
        }

        public final void setOutputModalities(Collection<String> outputModalities) {
            this.outputModalities = GuardrailModalitiesCopier.copy(outputModalities);
        }

        @Override
        public final Builder outputModalitiesWithStrings(Collection<String> outputModalities) {
            this.outputModalities = GuardrailModalitiesCopier.copy(outputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputModalitiesWithStrings(String ... outputModalities) {
            this.outputModalitiesWithStrings(Arrays.asList(outputModalities));
            return this;
        }

        @Override
        public final Builder outputModalities(Collection<GuardrailModality> outputModalities) {
            this.outputModalities = GuardrailModalitiesCopier.copyEnumToString(outputModalities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputModalities(GuardrailModality ... outputModalities) {
            this.outputModalities(Arrays.asList(outputModalities));
            return this;
        }

        public GuardrailContentFilter build() {
            return new GuardrailContentFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailContentFilter> {
        public Builder type(String var1);

        public Builder type(GuardrailContentFilterType var1);

        public Builder inputStrength(String var1);

        public Builder inputStrength(GuardrailFilterStrength var1);

        public Builder outputStrength(String var1);

        public Builder outputStrength(GuardrailFilterStrength var1);

        public Builder inputModalitiesWithStrings(Collection<String> var1);

        public Builder inputModalitiesWithStrings(String ... var1);

        public Builder inputModalities(Collection<GuardrailModality> var1);

        public Builder inputModalities(GuardrailModality ... var1);

        public Builder outputModalitiesWithStrings(Collection<String> var1);

        public Builder outputModalitiesWithStrings(String ... var1);

        public Builder outputModalities(Collection<GuardrailModality> var1);

        public Builder outputModalities(GuardrailModality ... var1);
    }
}

