/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrock.model.BedrockResponse;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummariesCopier;
import software.amazon.awssdk.services.bedrock.model.ModelInvocationJobSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListModelInvocationJobsResponse
extends BedrockResponse
implements ToCopyableBuilder<Builder, ListModelInvocationJobsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListModelInvocationJobsResponse.getter(ListModelInvocationJobsResponse::nextToken)).setter(ListModelInvocationJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<ModelInvocationJobSummary>> INVOCATION_JOB_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invocationJobSummaries").getter(ListModelInvocationJobsResponse.getter(ListModelInvocationJobsResponse::invocationJobSummaries)).setter(ListModelInvocationJobsResponse.setter(Builder::invocationJobSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationJobSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ModelInvocationJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, INVOCATION_JOB_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<ModelInvocationJobSummary> invocationJobSummaries;

    private ListModelInvocationJobsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.invocationJobSummaries = builder.invocationJobSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasInvocationJobSummaries() {
        return this.invocationJobSummaries != null && !(this.invocationJobSummaries instanceof SdkAutoConstructList);
    }

    public final List<ModelInvocationJobSummary> invocationJobSummaries() {
        return this.invocationJobSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvocationJobSummaries() ? this.invocationJobSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelInvocationJobsResponse)) {
            return false;
        }
        ListModelInvocationJobsResponse other = (ListModelInvocationJobsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasInvocationJobSummaries() == other.hasInvocationJobSummaries() && Objects.equals(this.invocationJobSummaries(), other.invocationJobSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListModelInvocationJobsResponse").add("NextToken", (Object)this.nextToken()).add("InvocationJobSummaries", this.hasInvocationJobSummaries() ? this.invocationJobSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "invocationJobSummaries": {
                return Optional.ofNullable(clazz.cast(this.invocationJobSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelInvocationJobsResponse, T> g) {
        return obj -> g.apply((ListModelInvocationJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<ModelInvocationJobSummary> invocationJobSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelInvocationJobsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.invocationJobSummaries(model.invocationJobSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ModelInvocationJobSummary.Builder> getInvocationJobSummaries() {
            List<ModelInvocationJobSummary.Builder> result = ModelInvocationJobSummariesCopier.copyToBuilder(this.invocationJobSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvocationJobSummaries(Collection<ModelInvocationJobSummary.BuilderImpl> invocationJobSummaries) {
            this.invocationJobSummaries = ModelInvocationJobSummariesCopier.copyFromBuilder(invocationJobSummaries);
        }

        @Override
        public final Builder invocationJobSummaries(Collection<ModelInvocationJobSummary> invocationJobSummaries) {
            this.invocationJobSummaries = ModelInvocationJobSummariesCopier.copy(invocationJobSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationJobSummaries(ModelInvocationJobSummary ... invocationJobSummaries) {
            this.invocationJobSummaries(Arrays.asList(invocationJobSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationJobSummaries(Consumer<ModelInvocationJobSummary.Builder> ... invocationJobSummaries) {
            this.invocationJobSummaries(Stream.of(invocationJobSummaries).map(c -> (ModelInvocationJobSummary)((ModelInvocationJobSummary.Builder)ModelInvocationJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListModelInvocationJobsResponse build() {
            return new ListModelInvocationJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BedrockResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListModelInvocationJobsResponse> {
        public Builder nextToken(String var1);

        public Builder invocationJobSummaries(Collection<ModelInvocationJobSummary> var1);

        public Builder invocationJobSummaries(ModelInvocationJobSummary ... var1);

        public Builder invocationJobSummaries(Consumer<ModelInvocationJobSummary.Builder> ... var1);
    }
}

