/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the configuration of the S3 location of the output data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelInvocationJobS3InputDataConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ModelInvocationJobS3InputDataConfig.Builder, ModelInvocationJobS3InputDataConfig> {
    private static final SdkField<String> S3_INPUT_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3InputFormat").getter(getter(ModelInvocationJobS3InputDataConfig::s3InputFormatAsString))
            .setter(setter(Builder::s3InputFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3InputFormat").build()).build();

    private static final SdkField<String> S3_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("s3Uri")
            .getter(getter(ModelInvocationJobS3InputDataConfig::s3Uri)).setter(setter(Builder::s3Uri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Uri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_INPUT_FORMAT_FIELD,
            S3_URI_FIELD));

    private static final long serialVersionUID = 1L;

    private final String s3InputFormat;

    private final String s3Uri;

    private ModelInvocationJobS3InputDataConfig(BuilderImpl builder) {
        this.s3InputFormat = builder.s3InputFormat;
        this.s3Uri = builder.s3Uri;
    }

    /**
     * <p>
     * The format of the input data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputFormat}
     * will return {@link S3InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3InputFormatAsString}.
     * </p>
     * 
     * @return The format of the input data.
     * @see S3InputFormat
     */
    public final S3InputFormat s3InputFormat() {
        return S3InputFormat.fromValue(s3InputFormat);
    }

    /**
     * <p>
     * The format of the input data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #s3InputFormat}
     * will return {@link S3InputFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #s3InputFormatAsString}.
     * </p>
     * 
     * @return The format of the input data.
     * @see S3InputFormat
     */
    public final String s3InputFormatAsString() {
        return s3InputFormat;
    }

    /**
     * <p>
     * The S3 location of the input data.
     * </p>
     * 
     * @return The S3 location of the input data.
     */
    public final String s3Uri() {
        return s3Uri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(s3InputFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(s3Uri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInvocationJobS3InputDataConfig)) {
            return false;
        }
        ModelInvocationJobS3InputDataConfig other = (ModelInvocationJobS3InputDataConfig) obj;
        return Objects.equals(s3InputFormatAsString(), other.s3InputFormatAsString()) && Objects.equals(s3Uri(), other.s3Uri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModelInvocationJobS3InputDataConfig").add("S3InputFormat", s3InputFormatAsString())
                .add("S3Uri", s3Uri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3InputFormat":
            return Optional.ofNullable(clazz.cast(s3InputFormatAsString()));
        case "s3Uri":
            return Optional.ofNullable(clazz.cast(s3Uri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelInvocationJobS3InputDataConfig, T> g) {
        return obj -> g.apply((ModelInvocationJobS3InputDataConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelInvocationJobS3InputDataConfig> {
        /**
         * <p>
         * The format of the input data.
         * </p>
         * 
         * @param s3InputFormat
         *        The format of the input data.
         * @see S3InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3InputFormat
         */
        Builder s3InputFormat(String s3InputFormat);

        /**
         * <p>
         * The format of the input data.
         * </p>
         * 
         * @param s3InputFormat
         *        The format of the input data.
         * @see S3InputFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see S3InputFormat
         */
        Builder s3InputFormat(S3InputFormat s3InputFormat);

        /**
         * <p>
         * The S3 location of the input data.
         * </p>
         * 
         * @param s3Uri
         *        The S3 location of the input data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Uri(String s3Uri);
    }

    static final class BuilderImpl implements Builder {
        private String s3InputFormat;

        private String s3Uri;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInvocationJobS3InputDataConfig model) {
            s3InputFormat(model.s3InputFormat);
            s3Uri(model.s3Uri);
        }

        public final String getS3InputFormat() {
            return s3InputFormat;
        }

        public final void setS3InputFormat(String s3InputFormat) {
            this.s3InputFormat = s3InputFormat;
        }

        @Override
        public final Builder s3InputFormat(String s3InputFormat) {
            this.s3InputFormat = s3InputFormat;
            return this;
        }

        @Override
        public final Builder s3InputFormat(S3InputFormat s3InputFormat) {
            this.s3InputFormat(s3InputFormat == null ? null : s3InputFormat.toString());
            return this;
        }

        public final String getS3Uri() {
            return s3Uri;
        }

        public final void setS3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
        }

        @Override
        public final Builder s3Uri(String s3Uri) {
            this.s3Uri = s3Uri;
            return this;
        }

        @Override
        public ModelInvocationJobS3InputDataConfig build() {
            return new ModelInvocationJobS3InputDataConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
