/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration fields for invocation logging.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LoggingConfig implements SdkPojo, Serializable, ToCopyableBuilder<LoggingConfig.Builder, LoggingConfig> {
    private static final SdkField<CloudWatchConfig> CLOUD_WATCH_CONFIG_FIELD = SdkField
            .<CloudWatchConfig> builder(MarshallingType.SDK_POJO).memberName("cloudWatchConfig")
            .getter(getter(LoggingConfig::cloudWatchConfig)).setter(setter(Builder::cloudWatchConfig))
            .constructor(CloudWatchConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchConfig").build()).build();

    private static final SdkField<S3Config> S3_CONFIG_FIELD = SdkField.<S3Config> builder(MarshallingType.SDK_POJO)
            .memberName("s3Config").getter(getter(LoggingConfig::s3Config)).setter(setter(Builder::s3Config))
            .constructor(S3Config::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Config").build()).build();

    private static final SdkField<Boolean> TEXT_DATA_DELIVERY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("textDataDeliveryEnabled").getter(getter(LoggingConfig::textDataDeliveryEnabled))
            .setter(setter(Builder::textDataDeliveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textDataDeliveryEnabled").build())
            .build();

    private static final SdkField<Boolean> IMAGE_DATA_DELIVERY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN).memberName("imageDataDeliveryEnabled")
            .getter(getter(LoggingConfig::imageDataDeliveryEnabled)).setter(setter(Builder::imageDataDeliveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDataDeliveryEnabled").build())
            .build();

    private static final SdkField<Boolean> EMBEDDING_DATA_DELIVERY_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("embeddingDataDeliveryEnabled")
            .getter(getter(LoggingConfig::embeddingDataDeliveryEnabled))
            .setter(setter(Builder::embeddingDataDeliveryEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("embeddingDataDeliveryEnabled")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_CONFIG_FIELD,
            S3_CONFIG_FIELD, TEXT_DATA_DELIVERY_ENABLED_FIELD, IMAGE_DATA_DELIVERY_ENABLED_FIELD,
            EMBEDDING_DATA_DELIVERY_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final CloudWatchConfig cloudWatchConfig;

    private final S3Config s3Config;

    private final Boolean textDataDeliveryEnabled;

    private final Boolean imageDataDeliveryEnabled;

    private final Boolean embeddingDataDeliveryEnabled;

    private LoggingConfig(BuilderImpl builder) {
        this.cloudWatchConfig = builder.cloudWatchConfig;
        this.s3Config = builder.s3Config;
        this.textDataDeliveryEnabled = builder.textDataDeliveryEnabled;
        this.imageDataDeliveryEnabled = builder.imageDataDeliveryEnabled;
        this.embeddingDataDeliveryEnabled = builder.embeddingDataDeliveryEnabled;
    }

    /**
     * <p>
     * CloudWatch logging configuration.
     * </p>
     * 
     * @return CloudWatch logging configuration.
     */
    public final CloudWatchConfig cloudWatchConfig() {
        return cloudWatchConfig;
    }

    /**
     * <p>
     * S3 configuration for storing log data.
     * </p>
     * 
     * @return S3 configuration for storing log data.
     */
    public final S3Config s3Config() {
        return s3Config;
    }

    /**
     * <p>
     * Set to include text data in the log delivery.
     * </p>
     * 
     * @return Set to include text data in the log delivery.
     */
    public final Boolean textDataDeliveryEnabled() {
        return textDataDeliveryEnabled;
    }

    /**
     * <p>
     * Set to include image data in the log delivery.
     * </p>
     * 
     * @return Set to include image data in the log delivery.
     */
    public final Boolean imageDataDeliveryEnabled() {
        return imageDataDeliveryEnabled;
    }

    /**
     * <p>
     * Set to include embeddings data in the log delivery.
     * </p>
     * 
     * @return Set to include embeddings data in the log delivery.
     */
    public final Boolean embeddingDataDeliveryEnabled() {
        return embeddingDataDeliveryEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchConfig());
        hashCode = 31 * hashCode + Objects.hashCode(s3Config());
        hashCode = 31 * hashCode + Objects.hashCode(textDataDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(imageDataDeliveryEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(embeddingDataDeliveryEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoggingConfig)) {
            return false;
        }
        LoggingConfig other = (LoggingConfig) obj;
        return Objects.equals(cloudWatchConfig(), other.cloudWatchConfig()) && Objects.equals(s3Config(), other.s3Config())
                && Objects.equals(textDataDeliveryEnabled(), other.textDataDeliveryEnabled())
                && Objects.equals(imageDataDeliveryEnabled(), other.imageDataDeliveryEnabled())
                && Objects.equals(embeddingDataDeliveryEnabled(), other.embeddingDataDeliveryEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LoggingConfig").add("CloudWatchConfig", cloudWatchConfig()).add("S3Config", s3Config())
                .add("TextDataDeliveryEnabled", textDataDeliveryEnabled())
                .add("ImageDataDeliveryEnabled", imageDataDeliveryEnabled())
                .add("EmbeddingDataDeliveryEnabled", embeddingDataDeliveryEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudWatchConfig":
            return Optional.ofNullable(clazz.cast(cloudWatchConfig()));
        case "s3Config":
            return Optional.ofNullable(clazz.cast(s3Config()));
        case "textDataDeliveryEnabled":
            return Optional.ofNullable(clazz.cast(textDataDeliveryEnabled()));
        case "imageDataDeliveryEnabled":
            return Optional.ofNullable(clazz.cast(imageDataDeliveryEnabled()));
        case "embeddingDataDeliveryEnabled":
            return Optional.ofNullable(clazz.cast(embeddingDataDeliveryEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoggingConfig, T> g) {
        return obj -> g.apply((LoggingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LoggingConfig> {
        /**
         * <p>
         * CloudWatch logging configuration.
         * </p>
         * 
         * @param cloudWatchConfig
         *        CloudWatch logging configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchConfig(CloudWatchConfig cloudWatchConfig);

        /**
         * <p>
         * CloudWatch logging configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchConfig.Builder} avoiding the
         * need to create one manually via {@link CloudWatchConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cloudWatchConfig(CloudWatchConfig)}.
         * 
         * @param cloudWatchConfig
         *        a consumer that will call methods on {@link CloudWatchConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchConfig(CloudWatchConfig)
         */
        default Builder cloudWatchConfig(Consumer<CloudWatchConfig.Builder> cloudWatchConfig) {
            return cloudWatchConfig(CloudWatchConfig.builder().applyMutation(cloudWatchConfig).build());
        }

        /**
         * <p>
         * S3 configuration for storing log data.
         * </p>
         * 
         * @param s3Config
         *        S3 configuration for storing log data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Config(S3Config s3Config);

        /**
         * <p>
         * S3 configuration for storing log data.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Config.Builder} avoiding the need to
         * create one manually via {@link S3Config#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Config.Builder#build()} is called immediately and its result is
         * passed to {@link #s3Config(S3Config)}.
         * 
         * @param s3Config
         *        a consumer that will call methods on {@link S3Config.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Config(S3Config)
         */
        default Builder s3Config(Consumer<S3Config.Builder> s3Config) {
            return s3Config(S3Config.builder().applyMutation(s3Config).build());
        }

        /**
         * <p>
         * Set to include text data in the log delivery.
         * </p>
         * 
         * @param textDataDeliveryEnabled
         *        Set to include text data in the log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textDataDeliveryEnabled(Boolean textDataDeliveryEnabled);

        /**
         * <p>
         * Set to include image data in the log delivery.
         * </p>
         * 
         * @param imageDataDeliveryEnabled
         *        Set to include image data in the log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDataDeliveryEnabled(Boolean imageDataDeliveryEnabled);

        /**
         * <p>
         * Set to include embeddings data in the log delivery.
         * </p>
         * 
         * @param embeddingDataDeliveryEnabled
         *        Set to include embeddings data in the log delivery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder embeddingDataDeliveryEnabled(Boolean embeddingDataDeliveryEnabled);
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchConfig cloudWatchConfig;

        private S3Config s3Config;

        private Boolean textDataDeliveryEnabled;

        private Boolean imageDataDeliveryEnabled;

        private Boolean embeddingDataDeliveryEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(LoggingConfig model) {
            cloudWatchConfig(model.cloudWatchConfig);
            s3Config(model.s3Config);
            textDataDeliveryEnabled(model.textDataDeliveryEnabled);
            imageDataDeliveryEnabled(model.imageDataDeliveryEnabled);
            embeddingDataDeliveryEnabled(model.embeddingDataDeliveryEnabled);
        }

        public final CloudWatchConfig.Builder getCloudWatchConfig() {
            return cloudWatchConfig != null ? cloudWatchConfig.toBuilder() : null;
        }

        public final void setCloudWatchConfig(CloudWatchConfig.BuilderImpl cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig != null ? cloudWatchConfig.build() : null;
        }

        @Override
        public final Builder cloudWatchConfig(CloudWatchConfig cloudWatchConfig) {
            this.cloudWatchConfig = cloudWatchConfig;
            return this;
        }

        public final S3Config.Builder getS3Config() {
            return s3Config != null ? s3Config.toBuilder() : null;
        }

        public final void setS3Config(S3Config.BuilderImpl s3Config) {
            this.s3Config = s3Config != null ? s3Config.build() : null;
        }

        @Override
        public final Builder s3Config(S3Config s3Config) {
            this.s3Config = s3Config;
            return this;
        }

        public final Boolean getTextDataDeliveryEnabled() {
            return textDataDeliveryEnabled;
        }

        public final void setTextDataDeliveryEnabled(Boolean textDataDeliveryEnabled) {
            this.textDataDeliveryEnabled = textDataDeliveryEnabled;
        }

        @Override
        public final Builder textDataDeliveryEnabled(Boolean textDataDeliveryEnabled) {
            this.textDataDeliveryEnabled = textDataDeliveryEnabled;
            return this;
        }

        public final Boolean getImageDataDeliveryEnabled() {
            return imageDataDeliveryEnabled;
        }

        public final void setImageDataDeliveryEnabled(Boolean imageDataDeliveryEnabled) {
            this.imageDataDeliveryEnabled = imageDataDeliveryEnabled;
        }

        @Override
        public final Builder imageDataDeliveryEnabled(Boolean imageDataDeliveryEnabled) {
            this.imageDataDeliveryEnabled = imageDataDeliveryEnabled;
            return this;
        }

        public final Boolean getEmbeddingDataDeliveryEnabled() {
            return embeddingDataDeliveryEnabled;
        }

        public final void setEmbeddingDataDeliveryEnabled(Boolean embeddingDataDeliveryEnabled) {
            this.embeddingDataDeliveryEnabled = embeddingDataDeliveryEnabled;
        }

        @Override
        public final Builder embeddingDataDeliveryEnabled(Boolean embeddingDataDeliveryEnabled) {
            this.embeddingDataDeliveryEnabled = embeddingDataDeliveryEnabled;
            return this;
        }

        @Override
        public LoggingConfig build() {
            return new LoggingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
