/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for the guardrails contextual grounding filter.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailContextualGroundingFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailContextualGroundingFilter.Builder, GuardrailContextualGroundingFilter> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailContextualGroundingFilter::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<Double> THRESHOLD_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("threshold").getter(getter(GuardrailContextualGroundingFilter::threshold))
            .setter(setter(Builder::threshold))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threshold").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, THRESHOLD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final Double threshold;

    private GuardrailContextualGroundingFilter(BuilderImpl builder) {
        this.type = builder.type;
        this.threshold = builder.threshold;
    }

    /**
     * <p>
     * The filter type details for the guardrails contextual grounding filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailContextualGroundingFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The filter type details for the guardrails contextual grounding filter.
     * @see GuardrailContextualGroundingFilterType
     */
    public final GuardrailContextualGroundingFilterType type() {
        return GuardrailContextualGroundingFilterType.fromValue(type);
    }

    /**
     * <p>
     * The filter type details for the guardrails contextual grounding filter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailContextualGroundingFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #typeAsString}.
     * </p>
     * 
     * @return The filter type details for the guardrails contextual grounding filter.
     * @see GuardrailContextualGroundingFilterType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The threshold details for the guardrails contextual grounding filter.
     * </p>
     * 
     * @return The threshold details for the guardrails contextual grounding filter.
     */
    public final Double threshold() {
        return threshold;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(threshold());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailContextualGroundingFilter)) {
            return false;
        }
        GuardrailContextualGroundingFilter other = (GuardrailContextualGroundingFilter) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(threshold(), other.threshold());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailContextualGroundingFilter").add("Type", typeAsString()).add("Threshold", threshold())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "threshold":
            return Optional.ofNullable(clazz.cast(threshold()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailContextualGroundingFilter, T> g) {
        return obj -> g.apply((GuardrailContextualGroundingFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailContextualGroundingFilter> {
        /**
         * <p>
         * The filter type details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param type
         *        The filter type details for the guardrails contextual grounding filter.
         * @see GuardrailContextualGroundingFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContextualGroundingFilterType
         */
        Builder type(String type);

        /**
         * <p>
         * The filter type details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param type
         *        The filter type details for the guardrails contextual grounding filter.
         * @see GuardrailContextualGroundingFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailContextualGroundingFilterType
         */
        Builder type(GuardrailContextualGroundingFilterType type);

        /**
         * <p>
         * The threshold details for the guardrails contextual grounding filter.
         * </p>
         * 
         * @param threshold
         *        The threshold details for the guardrails contextual grounding filter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threshold(Double threshold);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private Double threshold;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailContextualGroundingFilter model) {
            type(model.type);
            threshold(model.threshold);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailContextualGroundingFilterType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Double getThreshold() {
            return threshold;
        }

        public final void setThreshold(Double threshold) {
            this.threshold = threshold;
        }

        @Override
        public final Builder threshold(Double threshold) {
            this.threshold = threshold;
            return this;
        }

        @Override
        public GuardrailContextualGroundingFilter build() {
            return new GuardrailContextualGroundingFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
