/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The PII entity to configure for the guardrail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailPiiEntityConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailPiiEntityConfig.Builder, GuardrailPiiEntityConfig> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GuardrailPiiEntityConfig::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(GuardrailPiiEntityConfig::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, ACTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String action;

    private GuardrailPiiEntityConfig(BuilderImpl builder) {
        this.type = builder.type;
        this.action = builder.action;
    }

    /**
     * <p>
     * Configure guardrail type when the PII entity is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailPiiEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Configure guardrail type when the PII entity is detected.
     * @see GuardrailPiiEntityType
     */
    public final GuardrailPiiEntityType type() {
        return GuardrailPiiEntityType.fromValue(type);
    }

    /**
     * <p>
     * Configure guardrail type when the PII entity is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link GuardrailPiiEntityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Configure guardrail type when the PII entity is detected.
     * @see GuardrailPiiEntityType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Configure guardrail action when the PII entity is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return Configure guardrail action when the PII entity is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final GuardrailSensitiveInformationAction action() {
        return GuardrailSensitiveInformationAction.fromValue(action);
    }

    /**
     * <p>
     * Configure guardrail action when the PII entity is detected.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link GuardrailSensitiveInformationAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #actionAsString}.
     * </p>
     * 
     * @return Configure guardrail action when the PII entity is detected.
     * @see GuardrailSensitiveInformationAction
     */
    public final String actionAsString() {
        return action;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailPiiEntityConfig)) {
            return false;
        }
        GuardrailPiiEntityConfig other = (GuardrailPiiEntityConfig) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(actionAsString(), other.actionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailPiiEntityConfig").add("Type", typeAsString()).add("Action", actionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailPiiEntityConfig, T> g) {
        return obj -> g.apply((GuardrailPiiEntityConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailPiiEntityConfig> {
        /**
         * <p>
         * Configure guardrail type when the PII entity is detected.
         * </p>
         * 
         * @param type
         *        Configure guardrail type when the PII entity is detected.
         * @see GuardrailPiiEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailPiiEntityType
         */
        Builder type(String type);

        /**
         * <p>
         * Configure guardrail type when the PII entity is detected.
         * </p>
         * 
         * @param type
         *        Configure guardrail type when the PII entity is detected.
         * @see GuardrailPiiEntityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailPiiEntityType
         */
        Builder type(GuardrailPiiEntityType type);

        /**
         * <p>
         * Configure guardrail action when the PII entity is detected.
         * </p>
         * 
         * @param action
         *        Configure guardrail action when the PII entity is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(String action);

        /**
         * <p>
         * Configure guardrail action when the PII entity is detected.
         * </p>
         * 
         * @param action
         *        Configure guardrail action when the PII entity is detected.
         * @see GuardrailSensitiveInformationAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GuardrailSensitiveInformationAction
         */
        Builder action(GuardrailSensitiveInformationAction action);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String action;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailPiiEntityConfig model) {
            type(model.type);
            action(model.action);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GuardrailPiiEntityType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(GuardrailSensitiveInformationAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        @Override
        public GuardrailPiiEntityConfig build() {
            return new GuardrailPiiEntityConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
