/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomModelResponse extends BedrockResponse implements
        ToCopyableBuilder<GetCustomModelResponse.Builder, GetCustomModelResponse> {
    private static final SdkField<String> MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelArn").getter(getter(GetCustomModelResponse::modelArn)).setter(setter(Builder::modelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelArn").build()).build();

    private static final SdkField<String> MODEL_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelName").getter(getter(GetCustomModelResponse::modelName)).setter(setter(Builder::modelName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelName").build()).build();

    private static final SdkField<String> JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("jobName").getter(getter(GetCustomModelResponse::jobName)).setter(setter(Builder::jobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobName").build()).build();

    private static final SdkField<String> JOB_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobArn")
            .getter(getter(GetCustomModelResponse::jobArn)).setter(setter(Builder::jobArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobArn").build()).build();

    private static final SdkField<String> BASE_MODEL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("baseModelArn").getter(getter(GetCustomModelResponse::baseModelArn))
            .setter(setter(Builder::baseModelArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseModelArn").build()).build();

    private static final SdkField<String> CUSTOMIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customizationType").getter(getter(GetCustomModelResponse::customizationTypeAsString))
            .setter(setter(Builder::customizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customizationType").build()).build();

    private static final SdkField<String> MODEL_KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelKmsKeyArn").getter(getter(GetCustomModelResponse::modelKmsKeyArn))
            .setter(setter(Builder::modelKmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelKmsKeyArn").build()).build();

    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("hyperParameters")
            .getter(getter(GetCustomModelResponse::hyperParameters))
            .setter(setter(Builder::hyperParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hyperParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<TrainingDataConfig> TRAINING_DATA_CONFIG_FIELD = SdkField
            .<TrainingDataConfig> builder(MarshallingType.SDK_POJO).memberName("trainingDataConfig")
            .getter(getter(GetCustomModelResponse::trainingDataConfig)).setter(setter(Builder::trainingDataConfig))
            .constructor(TrainingDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingDataConfig").build())
            .build();

    private static final SdkField<ValidationDataConfig> VALIDATION_DATA_CONFIG_FIELD = SdkField
            .<ValidationDataConfig> builder(MarshallingType.SDK_POJO).memberName("validationDataConfig")
            .getter(getter(GetCustomModelResponse::validationDataConfig)).setter(setter(Builder::validationDataConfig))
            .constructor(ValidationDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationDataConfig").build())
            .build();

    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField
            .<OutputDataConfig> builder(MarshallingType.SDK_POJO).memberName("outputDataConfig")
            .getter(getter(GetCustomModelResponse::outputDataConfig)).setter(setter(Builder::outputDataConfig))
            .constructor(OutputDataConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputDataConfig").build()).build();

    private static final SdkField<TrainingMetrics> TRAINING_METRICS_FIELD = SdkField
            .<TrainingMetrics> builder(MarshallingType.SDK_POJO).memberName("trainingMetrics")
            .getter(getter(GetCustomModelResponse::trainingMetrics)).setter(setter(Builder::trainingMetrics))
            .constructor(TrainingMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetrics").build()).build();

    private static final SdkField<List<ValidatorMetric>> VALIDATION_METRICS_FIELD = SdkField
            .<List<ValidatorMetric>> builder(MarshallingType.LIST)
            .memberName("validationMetrics")
            .getter(getter(GetCustomModelResponse::validationMetrics))
            .setter(setter(Builder::validationMetrics))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validationMetrics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidatorMetric> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidatorMetric::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetCustomModelResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_ARN_FIELD,
            MODEL_NAME_FIELD, JOB_NAME_FIELD, JOB_ARN_FIELD, BASE_MODEL_ARN_FIELD, CUSTOMIZATION_TYPE_FIELD,
            MODEL_KMS_KEY_ARN_FIELD, HYPER_PARAMETERS_FIELD, TRAINING_DATA_CONFIG_FIELD, VALIDATION_DATA_CONFIG_FIELD,
            OUTPUT_DATA_CONFIG_FIELD, TRAINING_METRICS_FIELD, VALIDATION_METRICS_FIELD, CREATION_TIME_FIELD));

    private final String modelArn;

    private final String modelName;

    private final String jobName;

    private final String jobArn;

    private final String baseModelArn;

    private final String customizationType;

    private final String modelKmsKeyArn;

    private final Map<String, String> hyperParameters;

    private final TrainingDataConfig trainingDataConfig;

    private final ValidationDataConfig validationDataConfig;

    private final OutputDataConfig outputDataConfig;

    private final TrainingMetrics trainingMetrics;

    private final List<ValidatorMetric> validationMetrics;

    private final Instant creationTime;

    private GetCustomModelResponse(BuilderImpl builder) {
        super(builder);
        this.modelArn = builder.modelArn;
        this.modelName = builder.modelName;
        this.jobName = builder.jobName;
        this.jobArn = builder.jobArn;
        this.baseModelArn = builder.baseModelArn;
        this.customizationType = builder.customizationType;
        this.modelKmsKeyArn = builder.modelKmsKeyArn;
        this.hyperParameters = builder.hyperParameters;
        this.trainingDataConfig = builder.trainingDataConfig;
        this.validationDataConfig = builder.validationDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.trainingMetrics = builder.trainingMetrics;
        this.validationMetrics = builder.validationMetrics;
        this.creationTime = builder.creationTime;
    }

    /**
     * <p>
     * ARN associated with this model.
     * </p>
     * 
     * @return ARN associated with this model.
     */
    public final String modelArn() {
        return modelArn;
    }

    /**
     * <p>
     * Model name associated with this model.
     * </p>
     * 
     * @return Model name associated with this model.
     */
    public final String modelName() {
        return modelName;
    }

    /**
     * <p>
     * Job name associated with this model.
     * </p>
     * 
     * @return Job name associated with this model.
     */
    public final String jobName() {
        return jobName;
    }

    /**
     * <p>
     * Job ARN associated with this model.
     * </p>
     * 
     * @return Job ARN associated with this model.
     */
    public final String jobArn() {
        return jobArn;
    }

    /**
     * <p>
     * ARN of the base model.
     * </p>
     * 
     * @return ARN of the base model.
     */
    public final String baseModelArn() {
        return baseModelArn;
    }

    /**
     * <p>
     * The type of model customization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return The type of model customization.
     * @see CustomizationType
     */
    public final CustomizationType customizationType() {
        return CustomizationType.fromValue(customizationType);
    }

    /**
     * <p>
     * The type of model customization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #customizationType}
     * will return {@link CustomizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #customizationTypeAsString}.
     * </p>
     * 
     * @return The type of model customization.
     * @see CustomizationType
     */
    public final String customizationTypeAsString() {
        return customizationType;
    }

    /**
     * <p>
     * The custom model is encrypted at rest using this key.
     * </p>
     * 
     * @return The custom model is encrypted at rest using this key.
     */
    public final String modelKmsKeyArn() {
        return modelKmsKeyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the HyperParameters property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHyperParameters() {
        return hyperParameters != null && !(hyperParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Hyperparameter values associated with this model.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHyperParameters} method.
     * </p>
     * 
     * @return Hyperparameter values associated with this model.
     */
    public final Map<String, String> hyperParameters() {
        return hyperParameters;
    }

    /**
     * <p>
     * Information about the training dataset.
     * </p>
     * 
     * @return Information about the training dataset.
     */
    public final TrainingDataConfig trainingDataConfig() {
        return trainingDataConfig;
    }

    /**
     * Returns the value of the ValidationDataConfig property for this object.
     * 
     * @return The value of the ValidationDataConfig property for this object.
     */
    public final ValidationDataConfig validationDataConfig() {
        return validationDataConfig;
    }

    /**
     * <p>
     * Output data configuration associated with this custom model.
     * </p>
     * 
     * @return Output data configuration associated with this custom model.
     */
    public final OutputDataConfig outputDataConfig() {
        return outputDataConfig;
    }

    /**
     * <p>
     * The training metrics from the job creation.
     * </p>
     * 
     * @return The training metrics from the job creation.
     */
    public final TrainingMetrics trainingMetrics() {
        return trainingMetrics;
    }

    /**
     * For responses, this returns true if the service returned a value for the ValidationMetrics property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasValidationMetrics() {
        return validationMetrics != null && !(validationMetrics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The validation metrics from the job creation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValidationMetrics} method.
     * </p>
     * 
     * @return The validation metrics from the job creation.
     */
    public final List<ValidatorMetric> validationMetrics() {
        return validationMetrics;
    }

    /**
     * <p>
     * Creation time of the model.
     * </p>
     * 
     * @return Creation time of the model.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelArn());
        hashCode = 31 * hashCode + Objects.hashCode(modelName());
        hashCode = 31 * hashCode + Objects.hashCode(jobName());
        hashCode = 31 * hashCode + Objects.hashCode(jobArn());
        hashCode = 31 * hashCode + Objects.hashCode(baseModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(customizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modelKmsKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasHyperParameters() ? hyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(trainingDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(validationDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(trainingMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(hasValidationMetrics() ? validationMetrics() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomModelResponse)) {
            return false;
        }
        GetCustomModelResponse other = (GetCustomModelResponse) obj;
        return Objects.equals(modelArn(), other.modelArn()) && Objects.equals(modelName(), other.modelName())
                && Objects.equals(jobName(), other.jobName()) && Objects.equals(jobArn(), other.jobArn())
                && Objects.equals(baseModelArn(), other.baseModelArn())
                && Objects.equals(customizationTypeAsString(), other.customizationTypeAsString())
                && Objects.equals(modelKmsKeyArn(), other.modelKmsKeyArn()) && hasHyperParameters() == other.hasHyperParameters()
                && Objects.equals(hyperParameters(), other.hyperParameters())
                && Objects.equals(trainingDataConfig(), other.trainingDataConfig())
                && Objects.equals(validationDataConfig(), other.validationDataConfig())
                && Objects.equals(outputDataConfig(), other.outputDataConfig())
                && Objects.equals(trainingMetrics(), other.trainingMetrics())
                && hasValidationMetrics() == other.hasValidationMetrics()
                && Objects.equals(validationMetrics(), other.validationMetrics())
                && Objects.equals(creationTime(), other.creationTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomModelResponse").add("ModelArn", modelArn()).add("ModelName", modelName())
                .add("JobName", jobName()).add("JobArn", jobArn()).add("BaseModelArn", baseModelArn())
                .add("CustomizationType", customizationTypeAsString()).add("ModelKmsKeyArn", modelKmsKeyArn())
                .add("HyperParameters", hasHyperParameters() ? hyperParameters() : null)
                .add("TrainingDataConfig", trainingDataConfig()).add("ValidationDataConfig", validationDataConfig())
                .add("OutputDataConfig", outputDataConfig()).add("TrainingMetrics", trainingMetrics())
                .add("ValidationMetrics", hasValidationMetrics() ? validationMetrics() : null)
                .add("CreationTime", creationTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelArn":
            return Optional.ofNullable(clazz.cast(modelArn()));
        case "modelName":
            return Optional.ofNullable(clazz.cast(modelName()));
        case "jobName":
            return Optional.ofNullable(clazz.cast(jobName()));
        case "jobArn":
            return Optional.ofNullable(clazz.cast(jobArn()));
        case "baseModelArn":
            return Optional.ofNullable(clazz.cast(baseModelArn()));
        case "customizationType":
            return Optional.ofNullable(clazz.cast(customizationTypeAsString()));
        case "modelKmsKeyArn":
            return Optional.ofNullable(clazz.cast(modelKmsKeyArn()));
        case "hyperParameters":
            return Optional.ofNullable(clazz.cast(hyperParameters()));
        case "trainingDataConfig":
            return Optional.ofNullable(clazz.cast(trainingDataConfig()));
        case "validationDataConfig":
            return Optional.ofNullable(clazz.cast(validationDataConfig()));
        case "outputDataConfig":
            return Optional.ofNullable(clazz.cast(outputDataConfig()));
        case "trainingMetrics":
            return Optional.ofNullable(clazz.cast(trainingMetrics()));
        case "validationMetrics":
            return Optional.ofNullable(clazz.cast(validationMetrics()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCustomModelResponse, T> g) {
        return obj -> g.apply((GetCustomModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCustomModelResponse> {
        /**
         * <p>
         * ARN associated with this model.
         * </p>
         * 
         * @param modelArn
         *        ARN associated with this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelArn(String modelArn);

        /**
         * <p>
         * Model name associated with this model.
         * </p>
         * 
         * @param modelName
         *        Model name associated with this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelName(String modelName);

        /**
         * <p>
         * Job name associated with this model.
         * </p>
         * 
         * @param jobName
         *        Job name associated with this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobName(String jobName);

        /**
         * <p>
         * Job ARN associated with this model.
         * </p>
         * 
         * @param jobArn
         *        Job ARN associated with this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobArn(String jobArn);

        /**
         * <p>
         * ARN of the base model.
         * </p>
         * 
         * @param baseModelArn
         *        ARN of the base model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseModelArn(String baseModelArn);

        /**
         * <p>
         * The type of model customization.
         * </p>
         * 
         * @param customizationType
         *        The type of model customization.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(String customizationType);

        /**
         * <p>
         * The type of model customization.
         * </p>
         * 
         * @param customizationType
         *        The type of model customization.
         * @see CustomizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomizationType
         */
        Builder customizationType(CustomizationType customizationType);

        /**
         * <p>
         * The custom model is encrypted at rest using this key.
         * </p>
         * 
         * @param modelKmsKeyArn
         *        The custom model is encrypted at rest using this key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelKmsKeyArn(String modelKmsKeyArn);

        /**
         * <p>
         * Hyperparameter values associated with this model.
         * </p>
         * 
         * @param hyperParameters
         *        Hyperparameter values associated with this model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hyperParameters(Map<String, String> hyperParameters);

        /**
         * <p>
         * Information about the training dataset.
         * </p>
         * 
         * @param trainingDataConfig
         *        Information about the training dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingDataConfig(TrainingDataConfig trainingDataConfig);

        /**
         * <p>
         * Information about the training dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingDataConfig.Builder} avoiding the
         * need to create one manually via {@link TrainingDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingDataConfig(TrainingDataConfig)}.
         * 
         * @param trainingDataConfig
         *        a consumer that will call methods on {@link TrainingDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingDataConfig(TrainingDataConfig)
         */
        default Builder trainingDataConfig(Consumer<TrainingDataConfig.Builder> trainingDataConfig) {
            return trainingDataConfig(TrainingDataConfig.builder().applyMutation(trainingDataConfig).build());
        }

        /**
         * Sets the value of the ValidationDataConfig property for this object.
         *
         * @param validationDataConfig
         *        The new value for the ValidationDataConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationDataConfig(ValidationDataConfig validationDataConfig);

        /**
         * Sets the value of the ValidationDataConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ValidationDataConfig.Builder} avoiding
         * the need to create one manually via {@link ValidationDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ValidationDataConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #validationDataConfig(ValidationDataConfig)}.
         * 
         * @param validationDataConfig
         *        a consumer that will call methods on {@link ValidationDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationDataConfig(ValidationDataConfig)
         */
        default Builder validationDataConfig(Consumer<ValidationDataConfig.Builder> validationDataConfig) {
            return validationDataConfig(ValidationDataConfig.builder().applyMutation(validationDataConfig).build());
        }

        /**
         * <p>
         * Output data configuration associated with this custom model.
         * </p>
         * 
         * @param outputDataConfig
         *        Output data configuration associated with this custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputDataConfig(OutputDataConfig outputDataConfig);

        /**
         * <p>
         * Output data configuration associated with this custom model.
         * </p>
         * This is a convenience method that creates an instance of the {@link OutputDataConfig.Builder} avoiding the
         * need to create one manually via {@link OutputDataConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OutputDataConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #outputDataConfig(OutputDataConfig)}.
         * 
         * @param outputDataConfig
         *        a consumer that will call methods on {@link OutputDataConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #outputDataConfig(OutputDataConfig)
         */
        default Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return outputDataConfig(OutputDataConfig.builder().applyMutation(outputDataConfig).build());
        }

        /**
         * <p>
         * The training metrics from the job creation.
         * </p>
         * 
         * @param trainingMetrics
         *        The training metrics from the job creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trainingMetrics(TrainingMetrics trainingMetrics);

        /**
         * <p>
         * The training metrics from the job creation.
         * </p>
         * This is a convenience method that creates an instance of the {@link TrainingMetrics.Builder} avoiding the
         * need to create one manually via {@link TrainingMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TrainingMetrics.Builder#build()} is called immediately and its
         * result is passed to {@link #trainingMetrics(TrainingMetrics)}.
         * 
         * @param trainingMetrics
         *        a consumer that will call methods on {@link TrainingMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #trainingMetrics(TrainingMetrics)
         */
        default Builder trainingMetrics(Consumer<TrainingMetrics.Builder> trainingMetrics) {
            return trainingMetrics(TrainingMetrics.builder().applyMutation(trainingMetrics).build());
        }

        /**
         * <p>
         * The validation metrics from the job creation.
         * </p>
         * 
         * @param validationMetrics
         *        The validation metrics from the job creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMetrics(Collection<ValidatorMetric> validationMetrics);

        /**
         * <p>
         * The validation metrics from the job creation.
         * </p>
         * 
         * @param validationMetrics
         *        The validation metrics from the job creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationMetrics(ValidatorMetric... validationMetrics);

        /**
         * <p>
         * The validation metrics from the job creation.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric.Builder#build()} is called immediately
         * and its result is passed to {@link #validationMetrics(List<ValidatorMetric>)}.
         * 
         * @param validationMetrics
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrock.model.ValidatorMetric.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #validationMetrics(java.util.Collection<ValidatorMetric>)
         */
        Builder validationMetrics(Consumer<ValidatorMetric.Builder>... validationMetrics);

        /**
         * <p>
         * Creation time of the model.
         * </p>
         * 
         * @param creationTime
         *        Creation time of the model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);
    }

    static final class BuilderImpl extends BedrockResponse.BuilderImpl implements Builder {
        private String modelArn;

        private String modelName;

        private String jobName;

        private String jobArn;

        private String baseModelArn;

        private String customizationType;

        private String modelKmsKeyArn;

        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();

        private TrainingDataConfig trainingDataConfig;

        private ValidationDataConfig validationDataConfig;

        private OutputDataConfig outputDataConfig;

        private TrainingMetrics trainingMetrics;

        private List<ValidatorMetric> validationMetrics = DefaultSdkAutoConstructList.getInstance();

        private Instant creationTime;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomModelResponse model) {
            super(model);
            modelArn(model.modelArn);
            modelName(model.modelName);
            jobName(model.jobName);
            jobArn(model.jobArn);
            baseModelArn(model.baseModelArn);
            customizationType(model.customizationType);
            modelKmsKeyArn(model.modelKmsKeyArn);
            hyperParameters(model.hyperParameters);
            trainingDataConfig(model.trainingDataConfig);
            validationDataConfig(model.validationDataConfig);
            outputDataConfig(model.outputDataConfig);
            trainingMetrics(model.trainingMetrics);
            validationMetrics(model.validationMetrics);
            creationTime(model.creationTime);
        }

        public final String getModelArn() {
            return modelArn;
        }

        public final void setModelArn(String modelArn) {
            this.modelArn = modelArn;
        }

        @Override
        public final Builder modelArn(String modelArn) {
            this.modelArn = modelArn;
            return this;
        }

        public final String getModelName() {
            return modelName;
        }

        public final void setModelName(String modelName) {
            this.modelName = modelName;
        }

        @Override
        public final Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public final String getJobName() {
            return jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobArn() {
            return jobArn;
        }

        public final void setJobArn(String jobArn) {
            this.jobArn = jobArn;
        }

        @Override
        public final Builder jobArn(String jobArn) {
            this.jobArn = jobArn;
            return this;
        }

        public final String getBaseModelArn() {
            return baseModelArn;
        }

        public final void setBaseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
        }

        @Override
        public final Builder baseModelArn(String baseModelArn) {
            this.baseModelArn = baseModelArn;
            return this;
        }

        public final String getCustomizationType() {
            return customizationType;
        }

        public final void setCustomizationType(String customizationType) {
            this.customizationType = customizationType;
        }

        @Override
        public final Builder customizationType(String customizationType) {
            this.customizationType = customizationType;
            return this;
        }

        @Override
        public final Builder customizationType(CustomizationType customizationType) {
            this.customizationType(customizationType == null ? null : customizationType.toString());
            return this;
        }

        public final String getModelKmsKeyArn() {
            return modelKmsKeyArn;
        }

        public final void setModelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
        }

        @Override
        public final Builder modelKmsKeyArn(String modelKmsKeyArn) {
            this.modelKmsKeyArn = modelKmsKeyArn;
            return this;
        }

        public final Map<String, String> getHyperParameters() {
            if (hyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return hyperParameters;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = ModelCustomizationHyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final TrainingDataConfig.Builder getTrainingDataConfig() {
            return trainingDataConfig != null ? trainingDataConfig.toBuilder() : null;
        }

        public final void setTrainingDataConfig(TrainingDataConfig.BuilderImpl trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig != null ? trainingDataConfig.build() : null;
        }

        @Override
        public final Builder trainingDataConfig(TrainingDataConfig trainingDataConfig) {
            this.trainingDataConfig = trainingDataConfig;
            return this;
        }

        public final ValidationDataConfig.Builder getValidationDataConfig() {
            return validationDataConfig != null ? validationDataConfig.toBuilder() : null;
        }

        public final void setValidationDataConfig(ValidationDataConfig.BuilderImpl validationDataConfig) {
            this.validationDataConfig = validationDataConfig != null ? validationDataConfig.build() : null;
        }

        @Override
        public final Builder validationDataConfig(ValidationDataConfig validationDataConfig) {
            this.validationDataConfig = validationDataConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return outputDataConfig != null ? outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final TrainingMetrics.Builder getTrainingMetrics() {
            return trainingMetrics != null ? trainingMetrics.toBuilder() : null;
        }

        public final void setTrainingMetrics(TrainingMetrics.BuilderImpl trainingMetrics) {
            this.trainingMetrics = trainingMetrics != null ? trainingMetrics.build() : null;
        }

        @Override
        public final Builder trainingMetrics(TrainingMetrics trainingMetrics) {
            this.trainingMetrics = trainingMetrics;
            return this;
        }

        public final List<ValidatorMetric.Builder> getValidationMetrics() {
            List<ValidatorMetric.Builder> result = ValidationMetricsCopier.copyToBuilder(this.validationMetrics);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setValidationMetrics(Collection<ValidatorMetric.BuilderImpl> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copyFromBuilder(validationMetrics);
        }

        @Override
        public final Builder validationMetrics(Collection<ValidatorMetric> validationMetrics) {
            this.validationMetrics = ValidationMetricsCopier.copy(validationMetrics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(ValidatorMetric... validationMetrics) {
            validationMetrics(Arrays.asList(validationMetrics));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validationMetrics(Consumer<ValidatorMetric.Builder>... validationMetrics) {
            validationMetrics(Stream.of(validationMetrics).map(c -> ValidatorMetric.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        @Override
        public GetCustomModelResponse build() {
            return new GetCustomModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
