/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrock.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomModelRequest extends BedrockRequest implements
        ToCopyableBuilder<GetCustomModelRequest.Builder, GetCustomModelRequest> {
    private static final SdkField<String> MODEL_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("modelIdentifier").getter(getter(GetCustomModelRequest::modelIdentifier))
            .setter(setter(Builder::modelIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("modelIdentifier").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODEL_IDENTIFIER_FIELD));

    private final String modelIdentifier;

    private GetCustomModelRequest(BuilderImpl builder) {
        super(builder);
        this.modelIdentifier = builder.modelIdentifier;
    }

    /**
     * <p>
     * Name or ARN of the custom model.
     * </p>
     * 
     * @return Name or ARN of the custom model.
     */
    public final String modelIdentifier() {
        return modelIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(modelIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomModelRequest)) {
            return false;
        }
        GetCustomModelRequest other = (GetCustomModelRequest) obj;
        return Objects.equals(modelIdentifier(), other.modelIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomModelRequest").add("ModelIdentifier", modelIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "modelIdentifier":
            return Optional.ofNullable(clazz.cast(modelIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetCustomModelRequest, T> g) {
        return obj -> g.apply((GetCustomModelRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetCustomModelRequest> {
        /**
         * <p>
         * Name or ARN of the custom model.
         * </p>
         * 
         * @param modelIdentifier
         *        Name or ARN of the custom model.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder modelIdentifier(String modelIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockRequest.BuilderImpl implements Builder {
        private String modelIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomModelRequest model) {
            super(model);
            modelIdentifier(model.modelIdentifier);
        }

        public final String getModelIdentifier() {
            return modelIdentifier;
        }

        public final void setModelIdentifier(String modelIdentifier) {
            this.modelIdentifier = modelIdentifier;
        }

        @Override
        public final Builder modelIdentifier(String modelIdentifier) {
            this.modelIdentifier = modelIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCustomModelRequest build() {
            return new GetCustomModelRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
