/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmrecommendedactions.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ActionType;
import software.amazon.awssdk.services.bcmrecommendedactions.model.ContextCopier;
import software.amazon.awssdk.services.bcmrecommendedactions.model.Feature;
import software.amazon.awssdk.services.bcmrecommendedactions.model.NextStepsCopier;
import software.amazon.awssdk.services.bcmrecommendedactions.model.Severity;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendedAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendedAction> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(RecommendedAction.getter(RecommendedAction::id)).setter(RecommendedAction.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(RecommendedAction.getter(RecommendedAction::typeAsString)).setter(RecommendedAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(RecommendedAction.getter(RecommendedAction::accountId)).setter(RecommendedAction.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<String> SEVERITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("severity").getter(RecommendedAction.getter(RecommendedAction::severityAsString)).setter(RecommendedAction.setter(Builder::severity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("severity").build()}).build();
    private static final SdkField<String> FEATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("feature").getter(RecommendedAction.getter(RecommendedAction::featureAsString)).setter(RecommendedAction.setter(Builder::feature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("feature").build()}).build();
    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("context").getter(RecommendedAction.getter(RecommendedAction::context)).setter(RecommendedAction.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> NEXT_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nextSteps").getter(RecommendedAction.getter(RecommendedAction::nextSteps)).setter(RecommendedAction.setter(Builder::nextSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> LAST_UPDATED_TIME_STAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdatedTimeStamp").getter(RecommendedAction.getter(RecommendedAction::lastUpdatedTimeStamp)).setter(RecommendedAction.setter(Builder::lastUpdatedTimeStamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTimeStamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, ACCOUNT_ID_FIELD, SEVERITY_FIELD, FEATURE_FIELD, CONTEXT_FIELD, NEXT_STEPS_FIELD, LAST_UPDATED_TIME_STAMP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecommendedAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String accountId;
    private final String severity;
    private final String feature;
    private final Map<String, String> context;
    private final List<String> nextSteps;
    private final String lastUpdatedTimeStamp;

    private RecommendedAction(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.accountId = builder.accountId;
        this.severity = builder.severity;
        this.feature = builder.feature;
        this.context = builder.context;
        this.nextSteps = builder.nextSteps;
        this.lastUpdatedTimeStamp = builder.lastUpdatedTimeStamp;
    }

    public final String id() {
        return this.id;
    }

    public final ActionType type() {
        return ActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Severity severity() {
        return Severity.fromValue(this.severity);
    }

    public final String severityAsString() {
        return this.severity;
    }

    public final Feature feature() {
        return Feature.fromValue(this.feature);
    }

    public final String featureAsString() {
        return this.feature;
    }

    public final boolean hasContext() {
        return this.context != null && !(this.context instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> context() {
        return this.context;
    }

    public final boolean hasNextSteps() {
        return this.nextSteps != null && !(this.nextSteps instanceof SdkAutoConstructList);
    }

    public final List<String> nextSteps() {
        return this.nextSteps;
    }

    public final String lastUpdatedTimeStamp() {
        return this.lastUpdatedTimeStamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.featureAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContext() ? this.context() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextSteps() ? this.nextSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTimeStamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendedAction)) {
            return false;
        }
        RecommendedAction other = (RecommendedAction)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.severityAsString(), other.severityAsString()) && Objects.equals(this.featureAsString(), other.featureAsString()) && this.hasContext() == other.hasContext() && Objects.equals(this.context(), other.context()) && this.hasNextSteps() == other.hasNextSteps() && Objects.equals(this.nextSteps(), other.nextSteps()) && Objects.equals(this.lastUpdatedTimeStamp(), other.lastUpdatedTimeStamp());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendedAction").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("AccountId", (Object)this.accountId()).add("Severity", (Object)this.severityAsString()).add("Feature", (Object)this.featureAsString()).add("Context", this.hasContext() ? this.context() : null).add("NextSteps", this.hasNextSteps() ? this.nextSteps() : null).add("LastUpdatedTimeStamp", (Object)this.lastUpdatedTimeStamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "severity": {
                return Optional.ofNullable(clazz.cast(this.severityAsString()));
            }
            case "feature": {
                return Optional.ofNullable(clazz.cast(this.featureAsString()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "nextSteps": {
                return Optional.ofNullable(clazz.cast(this.nextSteps()));
            }
            case "lastUpdatedTimeStamp": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTimeStamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("severity", SEVERITY_FIELD);
        map.put("feature", FEATURE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("nextSteps", NEXT_STEPS_FIELD);
        map.put("lastUpdatedTimeStamp", LAST_UPDATED_TIME_STAMP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecommendedAction, T> g) {
        return obj -> g.apply((RecommendedAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String accountId;
        private String severity;
        private String feature;
        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();
        private List<String> nextSteps = DefaultSdkAutoConstructList.getInstance();
        private String lastUpdatedTimeStamp;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendedAction model) {
            this.id(model.id);
            this.type(model.type);
            this.accountId(model.accountId);
            this.severity(model.severity);
            this.feature(model.feature);
            this.context(model.context);
            this.nextSteps(model.nextSteps);
            this.lastUpdatedTimeStamp(model.lastUpdatedTimeStamp);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getSeverity() {
            return this.severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(Severity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final String getFeature() {
            return this.feature;
        }

        public final void setFeature(String feature) {
            this.feature = feature;
        }

        @Override
        public final Builder feature(String feature) {
            this.feature = feature;
            return this;
        }

        @Override
        public final Builder feature(Feature feature) {
            this.feature(feature == null ? null : feature.toString());
            return this;
        }

        public final Map<String, String> getContext() {
            if (this.context instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ContextCopier.copy(context);
            return this;
        }

        public final Collection<String> getNextSteps() {
            if (this.nextSteps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nextSteps;
        }

        public final void setNextSteps(Collection<String> nextSteps) {
            this.nextSteps = NextStepsCopier.copy(nextSteps);
        }

        @Override
        public final Builder nextSteps(Collection<String> nextSteps) {
            this.nextSteps = NextStepsCopier.copy(nextSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextSteps(String ... nextSteps) {
            this.nextSteps(Arrays.asList(nextSteps));
            return this;
        }

        public final String getLastUpdatedTimeStamp() {
            return this.lastUpdatedTimeStamp;
        }

        public final void setLastUpdatedTimeStamp(String lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
        }

        @Override
        public final Builder lastUpdatedTimeStamp(String lastUpdatedTimeStamp) {
            this.lastUpdatedTimeStamp = lastUpdatedTimeStamp;
            return this;
        }

        public RecommendedAction build() {
            return new RecommendedAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendedAction> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(ActionType var1);

        public Builder accountId(String var1);

        public Builder severity(String var1);

        public Builder severity(Severity var1);

        public Builder feature(String var1);

        public Builder feature(Feature var1);

        public Builder context(Map<String, String> var1);

        public Builder nextSteps(Collection<String> var1);

        public Builder nextSteps(String ... var1);

        public Builder lastUpdatedTimeStamp(String var1);
    }
}

