/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BcmPricingCalculatorResponse;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateCostSummary;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillEstimateStatus;
import software.amazon.awssdk.services.bcmpricingcalculator.model.BillInterval;
import software.amazon.awssdk.services.bcmpricingcalculator.model.GroupSharingPreferenceEnum;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBillEstimateResponse
extends BcmPricingCalculatorResponse
implements ToCopyableBuilder<Builder, CreateBillEstimateResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::id)).setter(CreateBillEstimateResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::name)).setter(CreateBillEstimateResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::statusAsString)).setter(CreateBillEstimateResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureMessage").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::failureMessage)).setter(CreateBillEstimateResponse.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureMessage").build()}).build();
    private static final SdkField<BillInterval> BILL_INTERVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("billInterval").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::billInterval)).setter(CreateBillEstimateResponse.setter(Builder::billInterval)).constructor(BillInterval::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billInterval").build()}).build();
    private static final SdkField<BillEstimateCostSummary> COST_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("costSummary").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::costSummary)).setter(CreateBillEstimateResponse.setter(Builder::costSummary)).constructor(BillEstimateCostSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costSummary").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::createdAt)).setter(CreateBillEstimateResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::expiresAt)).setter(CreateBillEstimateResponse.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()}).build();
    private static final SdkField<String> GROUP_SHARING_PREFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("groupSharingPreference").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::groupSharingPreferenceAsString)).setter(CreateBillEstimateResponse.setter(Builder::groupSharingPreference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupSharingPreference").build()}).build();
    private static final SdkField<String> COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("costCategoryGroupSharingPreferenceArn").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::costCategoryGroupSharingPreferenceArn)).setter(CreateBillEstimateResponse.setter(Builder::costCategoryGroupSharingPreferenceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCategoryGroupSharingPreferenceArn").build()}).build();
    private static final SdkField<Instant> COST_CATEGORY_GROUP_SHARING_PREFERENCE_EFFECTIVE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("costCategoryGroupSharingPreferenceEffectiveDate").getter(CreateBillEstimateResponse.getter(CreateBillEstimateResponse::costCategoryGroupSharingPreferenceEffectiveDate)).setter(CreateBillEstimateResponse.setter(Builder::costCategoryGroupSharingPreferenceEffectiveDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("costCategoryGroupSharingPreferenceEffectiveDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD, STATUS_FIELD, FAILURE_MESSAGE_FIELD, BILL_INTERVAL_FIELD, COST_SUMMARY_FIELD, CREATED_AT_FIELD, EXPIRES_AT_FIELD, GROUP_SHARING_PREFERENCE_FIELD, COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD, COST_CATEGORY_GROUP_SHARING_PREFERENCE_EFFECTIVE_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBillEstimateResponse.memberNameToFieldInitializer();
    private final String id;
    private final String name;
    private final String status;
    private final String failureMessage;
    private final BillInterval billInterval;
    private final BillEstimateCostSummary costSummary;
    private final Instant createdAt;
    private final Instant expiresAt;
    private final String groupSharingPreference;
    private final String costCategoryGroupSharingPreferenceArn;
    private final Instant costCategoryGroupSharingPreferenceEffectiveDate;

    private CreateBillEstimateResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.status = builder.status;
        this.failureMessage = builder.failureMessage;
        this.billInterval = builder.billInterval;
        this.costSummary = builder.costSummary;
        this.createdAt = builder.createdAt;
        this.expiresAt = builder.expiresAt;
        this.groupSharingPreference = builder.groupSharingPreference;
        this.costCategoryGroupSharingPreferenceArn = builder.costCategoryGroupSharingPreferenceArn;
        this.costCategoryGroupSharingPreferenceEffectiveDate = builder.costCategoryGroupSharingPreferenceEffectiveDate;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final BillEstimateStatus status() {
        return BillEstimateStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final BillInterval billInterval() {
        return this.billInterval;
    }

    public final BillEstimateCostSummary costSummary() {
        return this.costSummary;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public final GroupSharingPreferenceEnum groupSharingPreference() {
        return GroupSharingPreferenceEnum.fromValue(this.groupSharingPreference);
    }

    public final String groupSharingPreferenceAsString() {
        return this.groupSharingPreference;
    }

    public final String costCategoryGroupSharingPreferenceArn() {
        return this.costCategoryGroupSharingPreferenceArn;
    }

    public final Instant costCategoryGroupSharingPreferenceEffectiveDate() {
        return this.costCategoryGroupSharingPreferenceEffectiveDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.billInterval());
        hashCode = 31 * hashCode + Objects.hashCode(this.costSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupSharingPreferenceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryGroupSharingPreferenceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.costCategoryGroupSharingPreferenceEffectiveDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillEstimateResponse)) {
            return false;
        }
        CreateBillEstimateResponse other = (CreateBillEstimateResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureMessage(), other.failureMessage()) && Objects.equals(this.billInterval(), other.billInterval()) && Objects.equals(this.costSummary(), other.costSummary()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.expiresAt(), other.expiresAt()) && Objects.equals(this.groupSharingPreferenceAsString(), other.groupSharingPreferenceAsString()) && Objects.equals(this.costCategoryGroupSharingPreferenceArn(), other.costCategoryGroupSharingPreferenceArn()) && Objects.equals(this.costCategoryGroupSharingPreferenceEffectiveDate(), other.costCategoryGroupSharingPreferenceEffectiveDate());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBillEstimateResponse").add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Status", (Object)this.statusAsString()).add("FailureMessage", (Object)this.failureMessage()).add("BillInterval", (Object)this.billInterval()).add("CostSummary", (Object)this.costSummary()).add("CreatedAt", (Object)this.createdAt()).add("ExpiresAt", (Object)this.expiresAt()).add("GroupSharingPreference", (Object)this.groupSharingPreferenceAsString()).add("CostCategoryGroupSharingPreferenceArn", (Object)this.costCategoryGroupSharingPreferenceArn()).add("CostCategoryGroupSharingPreferenceEffectiveDate", (Object)this.costCategoryGroupSharingPreferenceEffectiveDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "failureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "billInterval": {
                return Optional.ofNullable(clazz.cast(this.billInterval()));
            }
            case "costSummary": {
                return Optional.ofNullable(clazz.cast(this.costSummary()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
            case "groupSharingPreference": {
                return Optional.ofNullable(clazz.cast(this.groupSharingPreferenceAsString()));
            }
            case "costCategoryGroupSharingPreferenceArn": {
                return Optional.ofNullable(clazz.cast(this.costCategoryGroupSharingPreferenceArn()));
            }
            case "costCategoryGroupSharingPreferenceEffectiveDate": {
                return Optional.ofNullable(clazz.cast(this.costCategoryGroupSharingPreferenceEffectiveDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("failureMessage", FAILURE_MESSAGE_FIELD);
        map.put("billInterval", BILL_INTERVAL_FIELD);
        map.put("costSummary", COST_SUMMARY_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("expiresAt", EXPIRES_AT_FIELD);
        map.put("groupSharingPreference", GROUP_SHARING_PREFERENCE_FIELD);
        map.put("costCategoryGroupSharingPreferenceArn", COST_CATEGORY_GROUP_SHARING_PREFERENCE_ARN_FIELD);
        map.put("costCategoryGroupSharingPreferenceEffectiveDate", COST_CATEGORY_GROUP_SHARING_PREFERENCE_EFFECTIVE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBillEstimateResponse, T> g) {
        return obj -> g.apply((CreateBillEstimateResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmPricingCalculatorResponse.BuilderImpl
    implements Builder {
        private String id;
        private String name;
        private String status;
        private String failureMessage;
        private BillInterval billInterval;
        private BillEstimateCostSummary costSummary;
        private Instant createdAt;
        private Instant expiresAt;
        private String groupSharingPreference;
        private String costCategoryGroupSharingPreferenceArn;
        private Instant costCategoryGroupSharingPreferenceEffectiveDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillEstimateResponse model) {
            super(model);
            this.id(model.id);
            this.name(model.name);
            this.status(model.status);
            this.failureMessage(model.failureMessage);
            this.billInterval(model.billInterval);
            this.costSummary(model.costSummary);
            this.createdAt(model.createdAt);
            this.expiresAt(model.expiresAt);
            this.groupSharingPreference(model.groupSharingPreference);
            this.costCategoryGroupSharingPreferenceArn(model.costCategoryGroupSharingPreferenceArn);
            this.costCategoryGroupSharingPreferenceEffectiveDate(model.costCategoryGroupSharingPreferenceEffectiveDate);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(BillEstimateStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final BillInterval.Builder getBillInterval() {
            return this.billInterval != null ? this.billInterval.toBuilder() : null;
        }

        public final void setBillInterval(BillInterval.BuilderImpl billInterval) {
            this.billInterval = billInterval != null ? billInterval.build() : null;
        }

        @Override
        public final Builder billInterval(BillInterval billInterval) {
            this.billInterval = billInterval;
            return this;
        }

        public final BillEstimateCostSummary.Builder getCostSummary() {
            return this.costSummary != null ? this.costSummary.toBuilder() : null;
        }

        public final void setCostSummary(BillEstimateCostSummary.BuilderImpl costSummary) {
            this.costSummary = costSummary != null ? costSummary.build() : null;
        }

        @Override
        public final Builder costSummary(BillEstimateCostSummary costSummary) {
            this.costSummary = costSummary;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public final String getGroupSharingPreference() {
            return this.groupSharingPreference;
        }

        public final void setGroupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
        }

        @Override
        public final Builder groupSharingPreference(String groupSharingPreference) {
            this.groupSharingPreference = groupSharingPreference;
            return this;
        }

        @Override
        public final Builder groupSharingPreference(GroupSharingPreferenceEnum groupSharingPreference) {
            this.groupSharingPreference(groupSharingPreference == null ? null : groupSharingPreference.toString());
            return this;
        }

        public final String getCostCategoryGroupSharingPreferenceArn() {
            return this.costCategoryGroupSharingPreferenceArn;
        }

        public final void setCostCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
        }

        @Override
        public final Builder costCategoryGroupSharingPreferenceArn(String costCategoryGroupSharingPreferenceArn) {
            this.costCategoryGroupSharingPreferenceArn = costCategoryGroupSharingPreferenceArn;
            return this;
        }

        public final Instant getCostCategoryGroupSharingPreferenceEffectiveDate() {
            return this.costCategoryGroupSharingPreferenceEffectiveDate;
        }

        public final void setCostCategoryGroupSharingPreferenceEffectiveDate(Instant costCategoryGroupSharingPreferenceEffectiveDate) {
            this.costCategoryGroupSharingPreferenceEffectiveDate = costCategoryGroupSharingPreferenceEffectiveDate;
        }

        @Override
        public final Builder costCategoryGroupSharingPreferenceEffectiveDate(Instant costCategoryGroupSharingPreferenceEffectiveDate) {
            this.costCategoryGroupSharingPreferenceEffectiveDate = costCategoryGroupSharingPreferenceEffectiveDate;
            return this;
        }

        @Override
        public CreateBillEstimateResponse build() {
            return new CreateBillEstimateResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmPricingCalculatorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBillEstimateResponse> {
        public Builder id(String var1);

        public Builder name(String var1);

        public Builder status(String var1);

        public Builder status(BillEstimateStatus var1);

        public Builder failureMessage(String var1);

        public Builder billInterval(BillInterval var1);

        default public Builder billInterval(Consumer<BillInterval.Builder> billInterval) {
            return this.billInterval((BillInterval)((BillInterval.Builder)BillInterval.builder().applyMutation(billInterval)).build());
        }

        public Builder costSummary(BillEstimateCostSummary var1);

        default public Builder costSummary(Consumer<BillEstimateCostSummary.Builder> costSummary) {
            return this.costSummary((BillEstimateCostSummary)((BillEstimateCostSummary.Builder)BillEstimateCostSummary.builder().applyMutation(costSummary)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder expiresAt(Instant var1);

        public Builder groupSharingPreference(String var1);

        public Builder groupSharingPreference(GroupSharingPreferenceEnum var1);

        public Builder costCategoryGroupSharingPreferenceArn(String var1);

        public Builder costCategoryGroupSharingPreferenceEffectiveDate(Instant var1);
    }
}

