/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExpressionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExpressionFilter> {
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(ExpressionFilter.getter(ExpressionFilter::key)).setter(ExpressionFilter.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<List<String>> MATCH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("matchOptions").getter(ExpressionFilter.getter(ExpressionFilter::matchOptions)).setter(ExpressionFilter.setter(Builder::matchOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("values").getter(ExpressionFilter.getter(ExpressionFilter::values)).setter(ExpressionFilter.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_FIELD, MATCH_OPTIONS_FIELD, VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExpressionFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String key;
    private final List<String> matchOptions;
    private final List<String> values;

    private ExpressionFilter(BuilderImpl builder) {
        this.key = builder.key;
        this.matchOptions = builder.matchOptions;
        this.values = builder.values;
    }

    public final String key() {
        return this.key;
    }

    public final boolean hasMatchOptions() {
        return this.matchOptions != null && !(this.matchOptions instanceof SdkAutoConstructList);
    }

    public final List<String> matchOptions() {
        return this.matchOptions;
    }

    public final boolean hasValues() {
        return this.values != null && !(this.values instanceof SdkAutoConstructList);
    }

    public final List<String> values() {
        return this.values;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMatchOptions() ? this.matchOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValues() ? this.values() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressionFilter)) {
            return false;
        }
        ExpressionFilter other = (ExpressionFilter)obj;
        return Objects.equals(this.key(), other.key()) && this.hasMatchOptions() == other.hasMatchOptions() && Objects.equals(this.matchOptions(), other.matchOptions()) && this.hasValues() == other.hasValues() && Objects.equals(this.values(), other.values());
    }

    public final String toString() {
        return ToString.builder((String)"ExpressionFilter").add("Key", (Object)this.key()).add("MatchOptions", this.hasMatchOptions() ? this.matchOptions() : null).add("Values", this.hasValues() ? this.values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "matchOptions": {
                return Optional.ofNullable(clazz.cast(this.matchOptions()));
            }
            case "values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("key", KEY_FIELD);
        map.put("matchOptions", MATCH_OPTIONS_FIELD);
        map.put("values", VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpressionFilter, T> g) {
        return obj -> g.apply((ExpressionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String key;
        private List<String> matchOptions = DefaultSdkAutoConstructList.getInstance();
        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressionFilter model) {
            this.key(model.key);
            this.matchOptions(model.matchOptions);
            this.values(model.values);
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final Collection<String> getMatchOptions() {
            if (this.matchOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.matchOptions;
        }

        public final void setMatchOptions(Collection<String> matchOptions) {
            this.matchOptions = StringListCopier.copy(matchOptions);
        }

        @Override
        public final Builder matchOptions(Collection<String> matchOptions) {
            this.matchOptions = StringListCopier.copy(matchOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder matchOptions(String ... matchOptions) {
            this.matchOptions(Arrays.asList(matchOptions));
            return this;
        }

        public final Collection<String> getValues() {
            if (this.values instanceof SdkAutoConstructList) {
                return null;
            }
            return this.values;
        }

        public final void setValues(Collection<String> values) {
            this.values = StringListCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = StringListCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public ExpressionFilter build() {
            return new ExpressionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExpressionFilter> {
        public Builder key(String var1);

        public Builder matchOptions(Collection<String> var1);

        public Builder matchOptions(String ... var1);

        public Builder values(Collection<String> var1);

        public Builder values(String ... var1);
    }
}

