/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmpricingcalculator.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bcmpricingcalculator.model.HistoricalUsageEntity;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmount;
import software.amazon.awssdk.services.bcmpricingcalculator.model.UsageAmountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCreateBillScenarioUsageModificationEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchCreateBillScenarioUsageModificationEntry> {
    private static final SdkField<String> SERVICE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceCode").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::serviceCode)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::serviceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceCode").build()}).build();
    private static final SdkField<String> USAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageType").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::usageType)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::usageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageType").build()}).build();
    private static final SdkField<String> OPERATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operation").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::operation)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::operation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operation").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("availabilityZone").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::availabilityZone)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("availabilityZone").build()}).build();
    private static final SdkField<String> KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("key").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::key)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::key)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("key").build()}).build();
    private static final SdkField<String> GROUP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("group").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::group)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::group)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("group").build()}).build();
    private static final SdkField<String> USAGE_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("usageAccountId").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::usageAccountId)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::usageAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageAccountId").build()}).build();
    private static final SdkField<List<UsageAmount>> AMOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("amounts").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::amounts)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::amounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UsageAmount::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<HistoricalUsageEntity> HISTORICAL_USAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("historicalUsage").getter(BatchCreateBillScenarioUsageModificationEntry.getter(BatchCreateBillScenarioUsageModificationEntry::historicalUsage)).setter(BatchCreateBillScenarioUsageModificationEntry.setter(Builder::historicalUsage)).constructor(HistoricalUsageEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("historicalUsage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_CODE_FIELD, USAGE_TYPE_FIELD, OPERATION_FIELD, AVAILABILITY_ZONE_FIELD, KEY_FIELD, GROUP_FIELD, USAGE_ACCOUNT_ID_FIELD, AMOUNTS_FIELD, HISTORICAL_USAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchCreateBillScenarioUsageModificationEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String serviceCode;
    private final String usageType;
    private final String operation;
    private final String availabilityZone;
    private final String key;
    private final String group;
    private final String usageAccountId;
    private final List<UsageAmount> amounts;
    private final HistoricalUsageEntity historicalUsage;

    private BatchCreateBillScenarioUsageModificationEntry(BuilderImpl builder) {
        this.serviceCode = builder.serviceCode;
        this.usageType = builder.usageType;
        this.operation = builder.operation;
        this.availabilityZone = builder.availabilityZone;
        this.key = builder.key;
        this.group = builder.group;
        this.usageAccountId = builder.usageAccountId;
        this.amounts = builder.amounts;
        this.historicalUsage = builder.historicalUsage;
    }

    public final String serviceCode() {
        return this.serviceCode;
    }

    public final String usageType() {
        return this.usageType;
    }

    public final String operation() {
        return this.operation;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String key() {
        return this.key;
    }

    public final String group() {
        return this.group;
    }

    public final String usageAccountId() {
        return this.usageAccountId;
    }

    public final boolean hasAmounts() {
        return this.amounts != null && !(this.amounts instanceof SdkAutoConstructList);
    }

    public final List<UsageAmount> amounts() {
        return this.amounts;
    }

    public final HistoricalUsageEntity historicalUsage() {
        return this.historicalUsage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageType());
        hashCode = 31 * hashCode + Objects.hashCode(this.operation());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.key());
        hashCode = 31 * hashCode + Objects.hashCode(this.group());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAmounts() ? this.amounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.historicalUsage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCreateBillScenarioUsageModificationEntry)) {
            return false;
        }
        BatchCreateBillScenarioUsageModificationEntry other = (BatchCreateBillScenarioUsageModificationEntry)obj;
        return Objects.equals(this.serviceCode(), other.serviceCode()) && Objects.equals(this.usageType(), other.usageType()) && Objects.equals(this.operation(), other.operation()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.key(), other.key()) && Objects.equals(this.group(), other.group()) && Objects.equals(this.usageAccountId(), other.usageAccountId()) && this.hasAmounts() == other.hasAmounts() && Objects.equals(this.amounts(), other.amounts()) && Objects.equals(this.historicalUsage(), other.historicalUsage());
    }

    public final String toString() {
        return ToString.builder((String)"BatchCreateBillScenarioUsageModificationEntry").add("ServiceCode", (Object)this.serviceCode()).add("UsageType", (Object)this.usageType()).add("Operation", (Object)this.operation()).add("AvailabilityZone", (Object)this.availabilityZone()).add("Key", (Object)this.key()).add("Group", (Object)this.group()).add("UsageAccountId", (Object)this.usageAccountId()).add("Amounts", this.hasAmounts() ? this.amounts() : null).add("HistoricalUsage", (Object)this.historicalUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceCode": {
                return Optional.ofNullable(clazz.cast(this.serviceCode()));
            }
            case "usageType": {
                return Optional.ofNullable(clazz.cast(this.usageType()));
            }
            case "operation": {
                return Optional.ofNullable(clazz.cast(this.operation()));
            }
            case "availabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "key": {
                return Optional.ofNullable(clazz.cast(this.key()));
            }
            case "group": {
                return Optional.ofNullable(clazz.cast(this.group()));
            }
            case "usageAccountId": {
                return Optional.ofNullable(clazz.cast(this.usageAccountId()));
            }
            case "amounts": {
                return Optional.ofNullable(clazz.cast(this.amounts()));
            }
            case "historicalUsage": {
                return Optional.ofNullable(clazz.cast(this.historicalUsage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("serviceCode", SERVICE_CODE_FIELD);
        map.put("usageType", USAGE_TYPE_FIELD);
        map.put("operation", OPERATION_FIELD);
        map.put("availabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("key", KEY_FIELD);
        map.put("group", GROUP_FIELD);
        map.put("usageAccountId", USAGE_ACCOUNT_ID_FIELD);
        map.put("amounts", AMOUNTS_FIELD);
        map.put("historicalUsage", HISTORICAL_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchCreateBillScenarioUsageModificationEntry, T> g) {
        return obj -> g.apply((BatchCreateBillScenarioUsageModificationEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String serviceCode;
        private String usageType;
        private String operation;
        private String availabilityZone;
        private String key;
        private String group;
        private String usageAccountId;
        private List<UsageAmount> amounts = DefaultSdkAutoConstructList.getInstance();
        private HistoricalUsageEntity historicalUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCreateBillScenarioUsageModificationEntry model) {
            this.serviceCode(model.serviceCode);
            this.usageType(model.usageType);
            this.operation(model.operation);
            this.availabilityZone(model.availabilityZone);
            this.key(model.key);
            this.group(model.group);
            this.usageAccountId(model.usageAccountId);
            this.amounts(model.amounts);
            this.historicalUsage(model.historicalUsage);
        }

        public final String getServiceCode() {
            return this.serviceCode;
        }

        public final void setServiceCode(String serviceCode) {
            this.serviceCode = serviceCode;
        }

        @Override
        public final Builder serviceCode(String serviceCode) {
            this.serviceCode = serviceCode;
            return this;
        }

        public final String getUsageType() {
            return this.usageType;
        }

        public final void setUsageType(String usageType) {
            this.usageType = usageType;
        }

        @Override
        public final Builder usageType(String usageType) {
            this.usageType = usageType;
            return this;
        }

        public final String getOperation() {
            return this.operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getKey() {
            return this.key;
        }

        public final void setKey(String key) {
            this.key = key;
        }

        @Override
        public final Builder key(String key) {
            this.key = key;
            return this;
        }

        public final String getGroup() {
            return this.group;
        }

        public final void setGroup(String group) {
            this.group = group;
        }

        @Override
        public final Builder group(String group) {
            this.group = group;
            return this;
        }

        public final String getUsageAccountId() {
            return this.usageAccountId;
        }

        public final void setUsageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
        }

        @Override
        public final Builder usageAccountId(String usageAccountId) {
            this.usageAccountId = usageAccountId;
            return this;
        }

        public final List<UsageAmount.Builder> getAmounts() {
            List<UsageAmount.Builder> result = UsageAmountsCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<UsageAmount.BuilderImpl> amounts) {
            this.amounts = UsageAmountsCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<UsageAmount> amounts) {
            this.amounts = UsageAmountsCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(UsageAmount ... amounts) {
            this.amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<UsageAmount.Builder> ... amounts) {
            this.amounts(Stream.of(amounts).map(c -> (UsageAmount)((UsageAmount.Builder)UsageAmount.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final HistoricalUsageEntity.Builder getHistoricalUsage() {
            return this.historicalUsage != null ? this.historicalUsage.toBuilder() : null;
        }

        public final void setHistoricalUsage(HistoricalUsageEntity.BuilderImpl historicalUsage) {
            this.historicalUsage = historicalUsage != null ? historicalUsage.build() : null;
        }

        @Override
        public final Builder historicalUsage(HistoricalUsageEntity historicalUsage) {
            this.historicalUsage = historicalUsage;
            return this;
        }

        public BatchCreateBillScenarioUsageModificationEntry build() {
            return new BatchCreateBillScenarioUsageModificationEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchCreateBillScenarioUsageModificationEntry> {
        public Builder serviceCode(String var1);

        public Builder usageType(String var1);

        public Builder operation(String var1);

        public Builder availabilityZone(String var1);

        public Builder key(String var1);

        public Builder group(String var1);

        public Builder usageAccountId(String var1);

        public Builder amounts(Collection<UsageAmount> var1);

        public Builder amounts(UsageAmount ... var1);

        public Builder amounts(Consumer<UsageAmount.Builder> ... var1);

        public Builder historicalUsage(HistoricalUsageEntity var1);

        default public Builder historicalUsage(Consumer<HistoricalUsageEntity.Builder> historicalUsage) {
            return this.historicalUsage((HistoricalUsageEntity)((HistoricalUsageEntity.Builder)HistoricalUsageEntity.builder().applyMutation(historicalUsage)).build());
        }
    }
}

