/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bcmdataexports.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bcmdataexports.model.BcmDataExportsRequest;
import software.amazon.awssdk.services.bcmdataexports.model.Export;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateExportRequest
extends BcmDataExportsRequest
implements ToCopyableBuilder<Builder, UpdateExportRequest> {
    private static final SdkField<Export> EXPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Export").getter(UpdateExportRequest.getter(UpdateExportRequest::export)).setter(UpdateExportRequest.setter(Builder::export)).constructor(Export::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Export").build()}).build();
    private static final SdkField<String> EXPORT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExportArn").getter(UpdateExportRequest.getter(UpdateExportRequest::exportArn)).setter(UpdateExportRequest.setter(Builder::exportArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_FIELD, EXPORT_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateExportRequest.memberNameToFieldInitializer();
    private final Export export;
    private final String exportArn;

    private UpdateExportRequest(BuilderImpl builder) {
        super(builder);
        this.export = builder.export;
        this.exportArn = builder.exportArn;
    }

    public final Export export() {
        return this.export;
    }

    public final String exportArn() {
        return this.exportArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.export());
        hashCode = 31 * hashCode + Objects.hashCode(this.exportArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateExportRequest)) {
            return false;
        }
        UpdateExportRequest other = (UpdateExportRequest)((Object)obj);
        return Objects.equals(this.export(), other.export()) && Objects.equals(this.exportArn(), other.exportArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateExportRequest").add("Export", (Object)this.export()).add("ExportArn", (Object)this.exportArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Export": {
                return Optional.ofNullable(clazz.cast(this.export()));
            }
            case "ExportArn": {
                return Optional.ofNullable(clazz.cast(this.exportArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Export", EXPORT_FIELD);
        map.put("ExportArn", EXPORT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateExportRequest, T> g) {
        return obj -> g.apply((UpdateExportRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BcmDataExportsRequest.BuilderImpl
    implements Builder {
        private Export export;
        private String exportArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateExportRequest model) {
            super(model);
            this.export(model.export);
            this.exportArn(model.exportArn);
        }

        public final Export.Builder getExport() {
            return this.export != null ? this.export.toBuilder() : null;
        }

        public final void setExport(Export.BuilderImpl export) {
            this.export = export != null ? export.build() : null;
        }

        @Override
        public final Builder export(Export export) {
            this.export = export;
            return this;
        }

        public final String getExportArn() {
            return this.exportArn;
        }

        public final void setExportArn(String exportArn) {
            this.exportArn = exportArn;
        }

        @Override
        public final Builder exportArn(String exportArn) {
            this.exportArn = exportArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateExportRequest build() {
            return new UpdateExportRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BcmDataExportsRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateExportRequest> {
        public Builder export(Export var1);

        default public Builder export(Consumer<Export.Builder> export) {
            return this.export((Export)((Export.Builder)Export.builder().applyMutation(export)).build());
        }

        public Builder exportArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

