/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceJobStatus {
    SUBMITTED("SUBMITTED"),
    PENDING("PENDING"),
    RUNNABLE("RUNNABLE"),
    SCHEDULED("SCHEDULED"),
    STARTING("STARTING"),
    RUNNING("RUNNING"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceJobStatus> VALUE_MAP;
    private final String value;

    private ServiceJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceJobStatus> knownValues() {
        EnumSet<ServiceJobStatus> knownValues = EnumSet.allOf(ServiceJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceJobStatus.class, ServiceJobStatus::toString);
    }
}

