/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ServiceEnvironmentStatus {
    CREATING("CREATING"),
    UPDATING("UPDATING"),
    DELETING("DELETING"),
    DELETED("DELETED"),
    VALID("VALID"),
    INVALID("INVALID"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ServiceEnvironmentStatus> VALUE_MAP;
    private final String value;

    private ServiceEnvironmentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ServiceEnvironmentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ServiceEnvironmentStatus> knownValues() {
        EnumSet<ServiceEnvironmentStatus> knownValues = EnumSet.allOf(ServiceEnvironmentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ServiceEnvironmentStatus.class, ServiceEnvironmentStatus::toString);
    }
}

