/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.EksContainerOverride;
import software.amazon.awssdk.services.batch.model.EksContainerOverrideListCopier;
import software.amazon.awssdk.services.batch.model.EksMetadata;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EksPodPropertiesOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EksPodPropertiesOverride> {
    private static final SdkField<List<EksContainerOverride>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(EksPodPropertiesOverride.getter(EksPodPropertiesOverride::containers)).setter(EksPodPropertiesOverride.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksContainerOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EksContainerOverride>> INIT_CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("initContainers").getter(EksPodPropertiesOverride.getter(EksPodPropertiesOverride::initContainers)).setter(EksPodPropertiesOverride.setter(Builder::initContainers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initContainers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EksContainerOverride::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<EksMetadata> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("metadata").getter(EksPodPropertiesOverride.getter(EksPodPropertiesOverride::metadata)).setter(EksPodPropertiesOverride.setter(Builder::metadata)).constructor(EksMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD, INIT_CONTAINERS_FIELD, METADATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EksPodPropertiesOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<EksContainerOverride> containers;
    private final List<EksContainerOverride> initContainers;
    private final EksMetadata metadata;

    private EksPodPropertiesOverride(BuilderImpl builder) {
        this.containers = builder.containers;
        this.initContainers = builder.initContainers;
        this.metadata = builder.metadata;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<EksContainerOverride> containers() {
        return this.containers;
    }

    public final boolean hasInitContainers() {
        return this.initContainers != null && !(this.initContainers instanceof SdkAutoConstructList);
    }

    public final List<EksContainerOverride> initContainers() {
        return this.initContainers;
    }

    public final EksMetadata metadata() {
        return this.metadata;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInitContainers() ? this.initContainers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.metadata());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EksPodPropertiesOverride)) {
            return false;
        }
        EksPodPropertiesOverride other = (EksPodPropertiesOverride)obj;
        return this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers()) && this.hasInitContainers() == other.hasInitContainers() && Objects.equals(this.initContainers(), other.initContainers()) && Objects.equals(this.metadata(), other.metadata());
    }

    public final String toString() {
        return ToString.builder((String)"EksPodPropertiesOverride").add("Containers", this.hasContainers() ? this.containers() : null).add("InitContainers", this.hasInitContainers() ? this.initContainers() : null).add("Metadata", (Object)this.metadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
            case "initContainers": {
                return Optional.ofNullable(clazz.cast(this.initContainers()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("containers", CONTAINERS_FIELD);
        map.put("initContainers", INIT_CONTAINERS_FIELD);
        map.put("metadata", METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EksPodPropertiesOverride, T> g) {
        return obj -> g.apply((EksPodPropertiesOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<EksContainerOverride> containers = DefaultSdkAutoConstructList.getInstance();
        private List<EksContainerOverride> initContainers = DefaultSdkAutoConstructList.getInstance();
        private EksMetadata metadata;

        private BuilderImpl() {
        }

        private BuilderImpl(EksPodPropertiesOverride model) {
            this.containers(model.containers);
            this.initContainers(model.initContainers);
            this.metadata(model.metadata);
        }

        public final List<EksContainerOverride.Builder> getContainers() {
            List<EksContainerOverride.Builder> result = EksContainerOverrideListCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<EksContainerOverride.BuilderImpl> containers) {
            this.containers = EksContainerOverrideListCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<EksContainerOverride> containers) {
            this.containers = EksContainerOverrideListCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(EksContainerOverride ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<EksContainerOverride.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (EksContainerOverride)((EksContainerOverride.Builder)EksContainerOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EksContainerOverride.Builder> getInitContainers() {
            List<EksContainerOverride.Builder> result = EksContainerOverrideListCopier.copyToBuilder(this.initContainers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInitContainers(Collection<EksContainerOverride.BuilderImpl> initContainers) {
            this.initContainers = EksContainerOverrideListCopier.copyFromBuilder(initContainers);
        }

        @Override
        public final Builder initContainers(Collection<EksContainerOverride> initContainers) {
            this.initContainers = EksContainerOverrideListCopier.copy(initContainers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initContainers(EksContainerOverride ... initContainers) {
            this.initContainers(Arrays.asList(initContainers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder initContainers(Consumer<EksContainerOverride.Builder> ... initContainers) {
            this.initContainers(Stream.of(initContainers).map(c -> (EksContainerOverride)((EksContainerOverride.Builder)EksContainerOverride.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final EksMetadata.Builder getMetadata() {
            return this.metadata != null ? this.metadata.toBuilder() : null;
        }

        public final void setMetadata(EksMetadata.BuilderImpl metadata) {
            this.metadata = metadata != null ? metadata.build() : null;
        }

        @Override
        public final Builder metadata(EksMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public EksPodPropertiesOverride build() {
            return new EksPodPropertiesOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EksPodPropertiesOverride> {
        public Builder containers(Collection<EksContainerOverride> var1);

        public Builder containers(EksContainerOverride ... var1);

        public Builder containers(Consumer<EksContainerOverride.Builder> ... var1);

        public Builder initContainers(Collection<EksContainerOverride> var1);

        public Builder initContainers(EksContainerOverride ... var1);

        public Builder initContainers(Consumer<EksContainerOverride.Builder> ... var1);

        public Builder metadata(EksMetadata var1);

        default public Builder metadata(Consumer<EksMetadata.Builder> metadata) {
            return this.metadata((EksMetadata)((EksMetadata.Builder)EksMetadata.builder().applyMutation(metadata)).build());
        }
    }
}

