/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteServiceEnvironmentRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, DeleteServiceEnvironmentRequest> {
    private static final SdkField<String> SERVICE_ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("serviceEnvironment").getter(DeleteServiceEnvironmentRequest.getter(DeleteServiceEnvironmentRequest::serviceEnvironment)).setter(DeleteServiceEnvironmentRequest.setter(Builder::serviceEnvironment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceEnvironment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteServiceEnvironmentRequest.memberNameToFieldInitializer();
    private final String serviceEnvironment;

    private DeleteServiceEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.serviceEnvironment = builder.serviceEnvironment;
    }

    public final String serviceEnvironment() {
        return this.serviceEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceEnvironment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteServiceEnvironmentRequest)) {
            return false;
        }
        DeleteServiceEnvironmentRequest other = (DeleteServiceEnvironmentRequest)((Object)obj);
        return Objects.equals(this.serviceEnvironment(), other.serviceEnvironment());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteServiceEnvironmentRequest").add("ServiceEnvironment", (Object)this.serviceEnvironment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceEnvironment": {
                return Optional.ofNullable(clazz.cast(this.serviceEnvironment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("serviceEnvironment", SERVICE_ENVIRONMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteServiceEnvironmentRequest, T> g) {
        return obj -> g.apply((DeleteServiceEnvironmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String serviceEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteServiceEnvironmentRequest model) {
            super(model);
            this.serviceEnvironment(model.serviceEnvironment);
        }

        public final String getServiceEnvironment() {
            return this.serviceEnvironment;
        }

        public final void setServiceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
        }

        @Override
        public final Builder serviceEnvironment(String serviceEnvironment) {
            this.serviceEnvironment = serviceEnvironment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteServiceEnvironmentRequest build() {
            return new DeleteServiceEnvironmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BatchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteServiceEnvironmentRequest> {
        public Builder serviceEnvironment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

