/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.internal.UserAgentUtils;
import software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesRequest;
import software.amazon.awssdk.services.batch.model.ListSchedulingPoliciesResponse;
import software.amazon.awssdk.services.batch.model.SchedulingPolicyListingDetail;

public class ListSchedulingPoliciesIterable
implements SdkIterable<ListSchedulingPoliciesResponse> {
    private final BatchClient client;
    private final ListSchedulingPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSchedulingPoliciesIterable(BatchClient client, ListSchedulingPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSchedulingPoliciesResponseFetcher();
    }

    public Iterator<ListSchedulingPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SchedulingPolicyListingDetail> schedulingPolicies() {
        Function<ListSchedulingPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.schedulingPolicies() != null) {
                return response.schedulingPolicies().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSchedulingPoliciesResponseFetcher
    implements SyncPageFetcher<ListSchedulingPoliciesResponse> {
        private ListSchedulingPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListSchedulingPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSchedulingPoliciesResponse nextPage(ListSchedulingPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListSchedulingPoliciesIterable.this.client.listSchedulingPolicies(ListSchedulingPoliciesIterable.this.firstRequest);
            }
            return ListSchedulingPoliciesIterable.this.client.listSchedulingPolicies((ListSchedulingPoliciesRequest)((Object)ListSchedulingPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

