/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.batch.model.ListTaskContainerOverridesCopier;
import software.amazon.awssdk.services.batch.model.TaskContainerOverrides;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TaskPropertiesOverride
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TaskPropertiesOverride> {
    private static final SdkField<List<TaskContainerOverrides>> CONTAINERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("containers").getter(TaskPropertiesOverride.getter(TaskPropertiesOverride::containers)).setter(TaskPropertiesOverride.setter(Builder::containers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TaskContainerOverrides::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TaskPropertiesOverride.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<TaskContainerOverrides> containers;

    private TaskPropertiesOverride(BuilderImpl builder) {
        this.containers = builder.containers;
    }

    public final boolean hasContainers() {
        return this.containers != null && !(this.containers instanceof SdkAutoConstructList);
    }

    public final List<TaskContainerOverrides> containers() {
        return this.containers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainers() ? this.containers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskPropertiesOverride)) {
            return false;
        }
        TaskPropertiesOverride other = (TaskPropertiesOverride)obj;
        return this.hasContainers() == other.hasContainers() && Objects.equals(this.containers(), other.containers());
    }

    public final String toString() {
        return ToString.builder((String)"TaskPropertiesOverride").add("Containers", this.hasContainers() ? this.containers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "containers": {
                return Optional.ofNullable(clazz.cast(this.containers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<TaskContainerOverrides>>> map = new HashMap<String, SdkField<List<TaskContainerOverrides>>>();
        map.put("containers", CONTAINERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskPropertiesOverride, T> g) {
        return obj -> g.apply((TaskPropertiesOverride)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<TaskContainerOverrides> containers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TaskPropertiesOverride model) {
            this.containers(model.containers);
        }

        public final List<TaskContainerOverrides.Builder> getContainers() {
            List<TaskContainerOverrides.Builder> result = ListTaskContainerOverridesCopier.copyToBuilder(this.containers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContainers(Collection<TaskContainerOverrides.BuilderImpl> containers) {
            this.containers = ListTaskContainerOverridesCopier.copyFromBuilder(containers);
        }

        @Override
        public final Builder containers(Collection<TaskContainerOverrides> containers) {
            this.containers = ListTaskContainerOverridesCopier.copy(containers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(TaskContainerOverrides ... containers) {
            this.containers(Arrays.asList(containers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containers(Consumer<TaskContainerOverrides.Builder> ... containers) {
            this.containers(Stream.of(containers).map(c -> (TaskContainerOverrides)((TaskContainerOverrides.Builder)TaskContainerOverrides.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TaskPropertiesOverride build() {
            return new TaskPropertiesOverride(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TaskPropertiesOverride> {
        public Builder containers(Collection<TaskContainerOverrides> var1);

        public Builder containers(TaskContainerOverrides ... var1);

        public Builder containers(Consumer<TaskContainerOverrides.Builder> ... var1);
    }
}

