/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchRequest;
import software.amazon.awssdk.services.backupsearch.model.ItemFilters;
import software.amazon.awssdk.services.backupsearch.model.SearchScope;
import software.amazon.awssdk.services.backupsearch.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartSearchJobRequest
extends BackupSearchRequest
implements ToCopyableBuilder<Builder, StartSearchJobRequest> {
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(StartSearchJobRequest.getter(StartSearchJobRequest::tags)).setter(StartSearchJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StartSearchJobRequest.getter(StartSearchJobRequest::name)).setter(StartSearchJobRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(StartSearchJobRequest.getter(StartSearchJobRequest::encryptionKeyArn)).setter(StartSearchJobRequest.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(StartSearchJobRequest.getter(StartSearchJobRequest::clientToken)).setter(StartSearchJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build()}).build();
    private static final SdkField<SearchScope> SEARCH_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SearchScope").getter(StartSearchJobRequest.getter(StartSearchJobRequest::searchScope)).setter(StartSearchJobRequest.setter(Builder::searchScope)).constructor(SearchScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchScope").build()}).build();
    private static final SdkField<ItemFilters> ITEM_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ItemFilters").getter(StartSearchJobRequest.getter(StartSearchJobRequest::itemFilters)).setter(StartSearchJobRequest.setter(Builder::itemFilters)).constructor(ItemFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ItemFilters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TAGS_FIELD, NAME_FIELD, ENCRYPTION_KEY_ARN_FIELD, CLIENT_TOKEN_FIELD, SEARCH_SCOPE_FIELD, ITEM_FILTERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartSearchJobRequest.memberNameToFieldInitializer();
    private final Map<String, String> tags;
    private final String name;
    private final String encryptionKeyArn;
    private final String clientToken;
    private final SearchScope searchScope;
    private final ItemFilters itemFilters;

    private StartSearchJobRequest(BuilderImpl builder) {
        super(builder);
        this.tags = builder.tags;
        this.name = builder.name;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.clientToken = builder.clientToken;
        this.searchScope = builder.searchScope;
        this.itemFilters = builder.itemFilters;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String name() {
        return this.name;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final SearchScope searchScope() {
        return this.searchScope;
    }

    public final ItemFilters itemFilters() {
        return this.itemFilters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.itemFilters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSearchJobRequest)) {
            return false;
        }
        StartSearchJobRequest other = (StartSearchJobRequest)((Object)obj);
        return this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.searchScope(), other.searchScope()) && Objects.equals(this.itemFilters(), other.itemFilters());
    }

    public final String toString() {
        return ToString.builder((String)"StartSearchJobRequest").add("Tags", this.hasTags() ? this.tags() : null).add("Name", (Object)this.name()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("ClientToken", (Object)this.clientToken()).add("SearchScope", (Object)this.searchScope()).add("ItemFilters", (Object)this.itemFilters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "SearchScope": {
                return Optional.ofNullable(clazz.cast(this.searchScope()));
            }
            case "ItemFilters": {
                return Optional.ofNullable(clazz.cast(this.itemFilters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Tags", TAGS_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("SearchScope", SEARCH_SCOPE_FIELD);
        map.put("ItemFilters", ITEM_FILTERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSearchJobRequest, T> g) {
        return obj -> g.apply((StartSearchJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchRequest.BuilderImpl
    implements Builder {
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String name;
        private String encryptionKeyArn;
        private String clientToken;
        private SearchScope searchScope;
        private ItemFilters itemFilters;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSearchJobRequest model) {
            super(model);
            this.tags(model.tags);
            this.name(model.name);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.clientToken(model.clientToken);
            this.searchScope(model.searchScope);
            this.itemFilters(model.itemFilters);
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final SearchScope.Builder getSearchScope() {
            return this.searchScope != null ? this.searchScope.toBuilder() : null;
        }

        public final void setSearchScope(SearchScope.BuilderImpl searchScope) {
            this.searchScope = searchScope != null ? searchScope.build() : null;
        }

        @Override
        public final Builder searchScope(SearchScope searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        public final ItemFilters.Builder getItemFilters() {
            return this.itemFilters != null ? this.itemFilters.toBuilder() : null;
        }

        public final void setItemFilters(ItemFilters.BuilderImpl itemFilters) {
            this.itemFilters = itemFilters != null ? itemFilters.build() : null;
        }

        @Override
        public final Builder itemFilters(ItemFilters itemFilters) {
            this.itemFilters = itemFilters;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSearchJobRequest build() {
            return new StartSearchJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupSearchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartSearchJobRequest> {
        public Builder tags(Map<String, String> var1);

        public Builder name(String var1);

        public Builder encryptionKeyArn(String var1);

        public Builder clientToken(String var1);

        public Builder searchScope(SearchScope var1);

        default public Builder searchScope(Consumer<SearchScope.Builder> searchScope) {
            return this.searchScope((SearchScope)((SearchScope.Builder)SearchScope.builder().applyMutation(searchScope)).build());
        }

        public Builder itemFilters(ItemFilters var1);

        default public Builder itemFilters(Consumer<ItemFilters.Builder> itemFilters) {
            return this.itemFilters((ItemFilters)((ItemFilters.Builder)ItemFilters.builder().applyMutation(itemFilters)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

