/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backupsearch.model.S3ExportSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExportSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExportSpecification> {
    private static final SdkField<S3ExportSpecification> S3_EXPORT_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3ExportSpecification").getter(ExportSpecification.getter(ExportSpecification::s3ExportSpecification)).setter(ExportSpecification.setter(Builder::s3ExportSpecification)).constructor(S3ExportSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3ExportSpecification").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_EXPORT_SPECIFICATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExportSpecification.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final S3ExportSpecification s3ExportSpecification;
    private final Type type;

    private ExportSpecification(BuilderImpl builder) {
        this.s3ExportSpecification = builder.s3ExportSpecification;
        this.type = builder.type;
    }

    public final S3ExportSpecification s3ExportSpecification() {
        return this.s3ExportSpecification;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.s3ExportSpecification());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExportSpecification)) {
            return false;
        }
        ExportSpecification other = (ExportSpecification)obj;
        return Objects.equals(this.s3ExportSpecification(), other.s3ExportSpecification());
    }

    public final String toString() {
        return ToString.builder((String)"ExportSpecification").add("S3ExportSpecification", (Object)this.s3ExportSpecification()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "s3ExportSpecification": {
                return Optional.ofNullable(clazz.cast(this.s3ExportSpecification()));
            }
        }
        return Optional.empty();
    }

    public static ExportSpecification fromS3ExportSpecification(S3ExportSpecification s3ExportSpecification) {
        return (ExportSpecification)ExportSpecification.builder().s3ExportSpecification(s3ExportSpecification).build();
    }

    public static ExportSpecification fromS3ExportSpecification(Consumer<S3ExportSpecification.Builder> s3ExportSpecification) {
        S3ExportSpecification.Builder builder = S3ExportSpecification.builder();
        s3ExportSpecification.accept(builder);
        return ExportSpecification.fromS3ExportSpecification((S3ExportSpecification)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<S3ExportSpecification>> map = new HashMap<String, SdkField<S3ExportSpecification>>();
        map.put("s3ExportSpecification", S3_EXPORT_SPECIFICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExportSpecification, T> g) {
        return obj -> g.apply((ExportSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        S3_EXPORT_SPECIFICATION,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private S3ExportSpecification s3ExportSpecification;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExportSpecification model) {
            this.s3ExportSpecification(model.s3ExportSpecification);
        }

        public final S3ExportSpecification.Builder getS3ExportSpecification() {
            return this.s3ExportSpecification != null ? this.s3ExportSpecification.toBuilder() : null;
        }

        public final void setS3ExportSpecification(S3ExportSpecification.BuilderImpl s3ExportSpecification) {
            S3ExportSpecification oldValue = this.s3ExportSpecification;
            this.s3ExportSpecification = s3ExportSpecification != null ? s3ExportSpecification.build() : null;
            this.handleUnionValueChange(Type.S3_EXPORT_SPECIFICATION, oldValue, this.s3ExportSpecification);
        }

        @Override
        public final Builder s3ExportSpecification(S3ExportSpecification s3ExportSpecification) {
            S3ExportSpecification oldValue = this.s3ExportSpecification;
            this.s3ExportSpecification = s3ExportSpecification;
            this.handleUnionValueChange(Type.S3_EXPORT_SPECIFICATION, oldValue, this.s3ExportSpecification);
            return this;
        }

        public ExportSpecification build() {
            return new ExportSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExportSpecification> {
        public Builder s3ExportSpecification(S3ExportSpecification var1);

        default public Builder s3ExportSpecification(Consumer<S3ExportSpecification.Builder> s3ExportSpecification) {
            return this.s3ExportSpecification((S3ExportSpecification)((S3ExportSpecification.Builder)S3ExportSpecification.builder().applyMutation(s3ExportSpecification)).build());
        }
    }
}

