/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupsearch.BackupSearchAsyncClient;
import software.amazon.awssdk.services.backupsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse;
import software.amazon.awssdk.services.backupsearch.model.ResultItem;

public class ListSearchJobResultsPublisher
implements SdkPublisher<ListSearchJobResultsResponse> {
    private final BackupSearchAsyncClient client;
    private final ListSearchJobResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSearchJobResultsPublisher(BackupSearchAsyncClient client, ListSearchJobResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSearchJobResultsPublisher(BackupSearchAsyncClient client, ListSearchJobResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSearchJobResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSearchJobResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ResultItem> results() {
        Function<ListSearchJobResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSearchJobResultsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSearchJobResultsResponseFetcher
    implements AsyncPageFetcher<ListSearchJobResultsResponse> {
        private ListSearchJobResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSearchJobResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSearchJobResultsResponse> nextPage(ListSearchJobResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSearchJobResultsPublisher.this.client.listSearchJobResults(ListSearchJobResultsPublisher.this.firstRequest);
            }
            return ListSearchJobResultsPublisher.this.client.listSearchJobResults((ListSearchJobResultsRequest)((Object)ListSearchJobResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

