/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StringConditionOperator {
    EQUALS_TO("EQUALS_TO"),
    NOT_EQUALS_TO("NOT_EQUALS_TO"),
    CONTAINS("CONTAINS"),
    DOES_NOT_CONTAIN("DOES_NOT_CONTAIN"),
    BEGINS_WITH("BEGINS_WITH"),
    ENDS_WITH("ENDS_WITH"),
    DOES_NOT_BEGIN_WITH("DOES_NOT_BEGIN_WITH"),
    DOES_NOT_END_WITH("DOES_NOT_END_WITH"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StringConditionOperator> VALUE_MAP;
    private final String value;

    private StringConditionOperator(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StringConditionOperator fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StringConditionOperator> knownValues() {
        EnumSet<StringConditionOperator> knownValues = EnumSet.allOf(StringConditionOperator.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StringConditionOperator.class, StringConditionOperator::toString);
    }
}

