/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupsearch.model.LongCondition;
import software.amazon.awssdk.services.backupsearch.model.LongConditionListCopier;
import software.amazon.awssdk.services.backupsearch.model.StringCondition;
import software.amazon.awssdk.services.backupsearch.model.StringConditionListCopier;
import software.amazon.awssdk.services.backupsearch.model.TimeCondition;
import software.amazon.awssdk.services.backupsearch.model.TimeConditionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3ItemFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3ItemFilter> {
    private static final SdkField<List<StringCondition>> OBJECT_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ObjectKeys").getter(S3ItemFilter.getter(S3ItemFilter::objectKeys)).setter(S3ItemFilter.setter(Builder::objectKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ObjectKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LongCondition>> SIZES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Sizes").getter(S3ItemFilter.getter(S3ItemFilter::sizes)).setter(S3ItemFilter.setter(Builder::sizes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sizes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LongCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<TimeCondition>> CREATION_TIMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CreationTimes").getter(S3ItemFilter.getter(S3ItemFilter::creationTimes)).setter(S3ItemFilter.setter(Builder::creationTimes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTimes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringCondition>> VERSION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VersionIds").getter(S3ItemFilter.getter(S3ItemFilter::versionIds)).setter(S3ItemFilter.setter(Builder::versionIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<StringCondition>> E_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ETags").getter(S3ItemFilter.getter(S3ItemFilter::eTags)).setter(S3ItemFilter.setter(Builder::eTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ETags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StringCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OBJECT_KEYS_FIELD, SIZES_FIELD, CREATION_TIMES_FIELD, VERSION_IDS_FIELD, E_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = S3ItemFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<StringCondition> objectKeys;
    private final List<LongCondition> sizes;
    private final List<TimeCondition> creationTimes;
    private final List<StringCondition> versionIds;
    private final List<StringCondition> eTags;

    private S3ItemFilter(BuilderImpl builder) {
        this.objectKeys = builder.objectKeys;
        this.sizes = builder.sizes;
        this.creationTimes = builder.creationTimes;
        this.versionIds = builder.versionIds;
        this.eTags = builder.eTags;
    }

    public final boolean hasObjectKeys() {
        return this.objectKeys != null && !(this.objectKeys instanceof SdkAutoConstructList);
    }

    public final List<StringCondition> objectKeys() {
        return this.objectKeys;
    }

    public final boolean hasSizes() {
        return this.sizes != null && !(this.sizes instanceof SdkAutoConstructList);
    }

    public final List<LongCondition> sizes() {
        return this.sizes;
    }

    public final boolean hasCreationTimes() {
        return this.creationTimes != null && !(this.creationTimes instanceof SdkAutoConstructList);
    }

    public final List<TimeCondition> creationTimes() {
        return this.creationTimes;
    }

    public final boolean hasVersionIds() {
        return this.versionIds != null && !(this.versionIds instanceof SdkAutoConstructList);
    }

    public final List<StringCondition> versionIds() {
        return this.versionIds;
    }

    public final boolean hasETags() {
        return this.eTags != null && !(this.eTags instanceof SdkAutoConstructList);
    }

    public final List<StringCondition> eTags() {
        return this.eTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasObjectKeys() ? this.objectKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSizes() ? this.sizes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCreationTimes() ? this.creationTimes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVersionIds() ? this.versionIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasETags() ? this.eTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3ItemFilter)) {
            return false;
        }
        S3ItemFilter other = (S3ItemFilter)obj;
        return this.hasObjectKeys() == other.hasObjectKeys() && Objects.equals(this.objectKeys(), other.objectKeys()) && this.hasSizes() == other.hasSizes() && Objects.equals(this.sizes(), other.sizes()) && this.hasCreationTimes() == other.hasCreationTimes() && Objects.equals(this.creationTimes(), other.creationTimes()) && this.hasVersionIds() == other.hasVersionIds() && Objects.equals(this.versionIds(), other.versionIds()) && this.hasETags() == other.hasETags() && Objects.equals(this.eTags(), other.eTags());
    }

    public final String toString() {
        return ToString.builder((String)"S3ItemFilter").add("ObjectKeys", this.hasObjectKeys() ? this.objectKeys() : null).add("Sizes", this.hasSizes() ? this.sizes() : null).add("CreationTimes", this.hasCreationTimes() ? this.creationTimes() : null).add("VersionIds", this.hasVersionIds() ? this.versionIds() : null).add("ETags", this.hasETags() ? this.eTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ObjectKeys": {
                return Optional.ofNullable(clazz.cast(this.objectKeys()));
            }
            case "Sizes": {
                return Optional.ofNullable(clazz.cast(this.sizes()));
            }
            case "CreationTimes": {
                return Optional.ofNullable(clazz.cast(this.creationTimes()));
            }
            case "VersionIds": {
                return Optional.ofNullable(clazz.cast(this.versionIds()));
            }
            case "ETags": {
                return Optional.ofNullable(clazz.cast(this.eTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ObjectKeys", OBJECT_KEYS_FIELD);
        map.put("Sizes", SIZES_FIELD);
        map.put("CreationTimes", CREATION_TIMES_FIELD);
        map.put("VersionIds", VERSION_IDS_FIELD);
        map.put("ETags", E_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3ItemFilter, T> g) {
        return obj -> g.apply((S3ItemFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<StringCondition> objectKeys = DefaultSdkAutoConstructList.getInstance();
        private List<LongCondition> sizes = DefaultSdkAutoConstructList.getInstance();
        private List<TimeCondition> creationTimes = DefaultSdkAutoConstructList.getInstance();
        private List<StringCondition> versionIds = DefaultSdkAutoConstructList.getInstance();
        private List<StringCondition> eTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(S3ItemFilter model) {
            this.objectKeys(model.objectKeys);
            this.sizes(model.sizes);
            this.creationTimes(model.creationTimes);
            this.versionIds(model.versionIds);
            this.eTags(model.eTags);
        }

        public final List<StringCondition.Builder> getObjectKeys() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.objectKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setObjectKeys(Collection<StringCondition.BuilderImpl> objectKeys) {
            this.objectKeys = StringConditionListCopier.copyFromBuilder(objectKeys);
        }

        @Override
        public final Builder objectKeys(Collection<StringCondition> objectKeys) {
            this.objectKeys = StringConditionListCopier.copy(objectKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectKeys(StringCondition ... objectKeys) {
            this.objectKeys(Arrays.asList(objectKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder objectKeys(Consumer<StringCondition.Builder> ... objectKeys) {
            this.objectKeys(Stream.of(objectKeys).map(c -> (StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<LongCondition.Builder> getSizes() {
            List<LongCondition.Builder> result = LongConditionListCopier.copyToBuilder(this.sizes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSizes(Collection<LongCondition.BuilderImpl> sizes) {
            this.sizes = LongConditionListCopier.copyFromBuilder(sizes);
        }

        @Override
        public final Builder sizes(Collection<LongCondition> sizes) {
            this.sizes = LongConditionListCopier.copy(sizes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(LongCondition ... sizes) {
            this.sizes(Arrays.asList(sizes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sizes(Consumer<LongCondition.Builder> ... sizes) {
            this.sizes(Stream.of(sizes).map(c -> (LongCondition)((LongCondition.Builder)LongCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<TimeCondition.Builder> getCreationTimes() {
            List<TimeCondition.Builder> result = TimeConditionListCopier.copyToBuilder(this.creationTimes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCreationTimes(Collection<TimeCondition.BuilderImpl> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copyFromBuilder(creationTimes);
        }

        @Override
        public final Builder creationTimes(Collection<TimeCondition> creationTimes) {
            this.creationTimes = TimeConditionListCopier.copy(creationTimes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(TimeCondition ... creationTimes) {
            this.creationTimes(Arrays.asList(creationTimes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder creationTimes(Consumer<TimeCondition.Builder> ... creationTimes) {
            this.creationTimes(Stream.of(creationTimes).map(c -> (TimeCondition)((TimeCondition.Builder)TimeCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringCondition.Builder> getVersionIds() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.versionIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVersionIds(Collection<StringCondition.BuilderImpl> versionIds) {
            this.versionIds = StringConditionListCopier.copyFromBuilder(versionIds);
        }

        @Override
        public final Builder versionIds(Collection<StringCondition> versionIds) {
            this.versionIds = StringConditionListCopier.copy(versionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionIds(StringCondition ... versionIds) {
            this.versionIds(Arrays.asList(versionIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder versionIds(Consumer<StringCondition.Builder> ... versionIds) {
            this.versionIds(Stream.of(versionIds).map(c -> (StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<StringCondition.Builder> getETags() {
            List<StringCondition.Builder> result = StringConditionListCopier.copyToBuilder(this.eTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setETags(Collection<StringCondition.BuilderImpl> eTags) {
            this.eTags = StringConditionListCopier.copyFromBuilder(eTags);
        }

        @Override
        public final Builder eTags(Collection<StringCondition> eTags) {
            this.eTags = StringConditionListCopier.copy(eTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eTags(StringCondition ... eTags) {
            this.eTags(Arrays.asList(eTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eTags(Consumer<StringCondition.Builder> ... eTags) {
            this.eTags(Stream.of(eTags).map(c -> (StringCondition)((StringCondition.Builder)StringCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public S3ItemFilter build() {
            return new S3ItemFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3ItemFilter> {
        public Builder objectKeys(Collection<StringCondition> var1);

        public Builder objectKeys(StringCondition ... var1);

        public Builder objectKeys(Consumer<StringCondition.Builder> ... var1);

        public Builder sizes(Collection<LongCondition> var1);

        public Builder sizes(LongCondition ... var1);

        public Builder sizes(Consumer<LongCondition.Builder> ... var1);

        public Builder creationTimes(Collection<TimeCondition> var1);

        public Builder creationTimes(TimeCondition ... var1);

        public Builder creationTimes(Consumer<TimeCondition.Builder> ... var1);

        public Builder versionIds(Collection<StringCondition> var1);

        public Builder versionIds(StringCondition ... var1);

        public Builder versionIds(Consumer<StringCondition.Builder> ... var1);

        public Builder eTags(Collection<StringCondition> var1);

        public Builder eTags(StringCondition ... var1);

        public Builder eTags(Consumer<StringCondition.Builder> ... var1);
    }
}

