/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchResponse;
import software.amazon.awssdk.services.backupsearch.model.SearchJobSummary;
import software.amazon.awssdk.services.backupsearch.model.SearchJobsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListSearchJobsResponse
extends BackupSearchResponse
implements ToCopyableBuilder<Builder, ListSearchJobsResponse> {
    private static final SdkField<List<SearchJobSummary>> SEARCH_JOBS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SearchJobs").getter(ListSearchJobsResponse.getter(ListSearchJobsResponse::searchJobs)).setter(ListSearchJobsResponse.setter(Builder::searchJobs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchJobs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchJobSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListSearchJobsResponse.getter(ListSearchJobsResponse::nextToken)).setter(ListSearchJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEARCH_JOBS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListSearchJobsResponse.memberNameToFieldInitializer();
    private final List<SearchJobSummary> searchJobs;
    private final String nextToken;

    private ListSearchJobsResponse(BuilderImpl builder) {
        super(builder);
        this.searchJobs = builder.searchJobs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasSearchJobs() {
        return this.searchJobs != null && !(this.searchJobs instanceof SdkAutoConstructList);
    }

    public final List<SearchJobSummary> searchJobs() {
        return this.searchJobs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchJobs() ? this.searchJobs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSearchJobsResponse)) {
            return false;
        }
        ListSearchJobsResponse other = (ListSearchJobsResponse)((Object)obj);
        return this.hasSearchJobs() == other.hasSearchJobs() && Objects.equals(this.searchJobs(), other.searchJobs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListSearchJobsResponse").add("SearchJobs", this.hasSearchJobs() ? this.searchJobs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SearchJobs": {
                return Optional.ofNullable(clazz.cast(this.searchJobs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SearchJobs", SEARCH_JOBS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSearchJobsResponse, T> g) {
        return obj -> g.apply((ListSearchJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupSearchResponse.BuilderImpl
    implements Builder {
        private List<SearchJobSummary> searchJobs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSearchJobsResponse model) {
            super(model);
            this.searchJobs(model.searchJobs);
            this.nextToken(model.nextToken);
        }

        public final List<SearchJobSummary.Builder> getSearchJobs() {
            List<SearchJobSummary.Builder> result = SearchJobsCopier.copyToBuilder(this.searchJobs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearchJobs(Collection<SearchJobSummary.BuilderImpl> searchJobs) {
            this.searchJobs = SearchJobsCopier.copyFromBuilder(searchJobs);
        }

        @Override
        public final Builder searchJobs(Collection<SearchJobSummary> searchJobs) {
            this.searchJobs = SearchJobsCopier.copy(searchJobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchJobs(SearchJobSummary ... searchJobs) {
            this.searchJobs(Arrays.asList(searchJobs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchJobs(Consumer<SearchJobSummary.Builder> ... searchJobs) {
            this.searchJobs(Stream.of(searchJobs).map(c -> (SearchJobSummary)((SearchJobSummary.Builder)SearchJobSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSearchJobsResponse build() {
            return new ListSearchJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListSearchJobsResponse> {
        public Builder searchJobs(Collection<SearchJobSummary> var1);

        public Builder searchJobs(SearchJobSummary ... var1);

        public Builder searchJobs(Consumer<SearchJobSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

