/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.backupsearch.BackupSearchAsyncClientBuilder;
import software.amazon.awssdk.services.backupsearch.BackupSearchServiceClientConfiguration;
import software.amazon.awssdk.services.backupsearch.DefaultBackupSearchAsyncClientBuilder;
import software.amazon.awssdk.services.backupsearch.model.GetSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.GetSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.GetSearchResultExportJobRequest;
import software.amazon.awssdk.services.backupsearch.model.GetSearchResultExportJobResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.backupsearch.model.StartSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StartSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.StartSearchResultExportJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StartSearchResultExportJobResponse;
import software.amazon.awssdk.services.backupsearch.model.StopSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StopSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.TagResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.TagResourceResponse;
import software.amazon.awssdk.services.backupsearch.model.UntagResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.UntagResourceResponse;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobBackupsPublisher;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobResultsPublisher;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobsPublisher;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchResultExportJobsPublisher;

@SdkPublicApi
@ThreadSafe
public interface BackupSearchAsyncClient
extends AwsClient {
    public static final String SERVICE_NAME = "backup-search";
    public static final String SERVICE_METADATA_ID = "backup-search";

    default public CompletableFuture<GetSearchJobResponse> getSearchJob(GetSearchJobRequest getSearchJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetSearchJobResponse> getSearchJob(Consumer<GetSearchJobRequest.Builder> getSearchJobRequest) {
        return this.getSearchJob((GetSearchJobRequest)((Object)((GetSearchJobRequest.Builder)GetSearchJobRequest.builder().applyMutation(getSearchJobRequest)).build()));
    }

    default public CompletableFuture<GetSearchResultExportJobResponse> getSearchResultExportJob(GetSearchResultExportJobRequest getSearchResultExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<GetSearchResultExportJobResponse> getSearchResultExportJob(Consumer<GetSearchResultExportJobRequest.Builder> getSearchResultExportJobRequest) {
        return this.getSearchResultExportJob((GetSearchResultExportJobRequest)((Object)((GetSearchResultExportJobRequest.Builder)GetSearchResultExportJobRequest.builder().applyMutation(getSearchResultExportJobRequest)).build()));
    }

    default public CompletableFuture<ListSearchJobBackupsResponse> listSearchJobBackups(ListSearchJobBackupsRequest listSearchJobBackupsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListSearchJobBackupsResponse> listSearchJobBackups(Consumer<ListSearchJobBackupsRequest.Builder> listSearchJobBackupsRequest) {
        return this.listSearchJobBackups((ListSearchJobBackupsRequest)((Object)((ListSearchJobBackupsRequest.Builder)ListSearchJobBackupsRequest.builder().applyMutation(listSearchJobBackupsRequest)).build()));
    }

    default public ListSearchJobBackupsPublisher listSearchJobBackupsPaginator(ListSearchJobBackupsRequest listSearchJobBackupsRequest) {
        return new ListSearchJobBackupsPublisher(this, listSearchJobBackupsRequest);
    }

    default public ListSearchJobBackupsPublisher listSearchJobBackupsPaginator(Consumer<ListSearchJobBackupsRequest.Builder> listSearchJobBackupsRequest) {
        return this.listSearchJobBackupsPaginator((ListSearchJobBackupsRequest)((Object)((ListSearchJobBackupsRequest.Builder)ListSearchJobBackupsRequest.builder().applyMutation(listSearchJobBackupsRequest)).build()));
    }

    default public CompletableFuture<ListSearchJobResultsResponse> listSearchJobResults(ListSearchJobResultsRequest listSearchJobResultsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListSearchJobResultsResponse> listSearchJobResults(Consumer<ListSearchJobResultsRequest.Builder> listSearchJobResultsRequest) {
        return this.listSearchJobResults((ListSearchJobResultsRequest)((Object)((ListSearchJobResultsRequest.Builder)ListSearchJobResultsRequest.builder().applyMutation(listSearchJobResultsRequest)).build()));
    }

    default public ListSearchJobResultsPublisher listSearchJobResultsPaginator(ListSearchJobResultsRequest listSearchJobResultsRequest) {
        return new ListSearchJobResultsPublisher(this, listSearchJobResultsRequest);
    }

    default public ListSearchJobResultsPublisher listSearchJobResultsPaginator(Consumer<ListSearchJobResultsRequest.Builder> listSearchJobResultsRequest) {
        return this.listSearchJobResultsPaginator((ListSearchJobResultsRequest)((Object)((ListSearchJobResultsRequest.Builder)ListSearchJobResultsRequest.builder().applyMutation(listSearchJobResultsRequest)).build()));
    }

    default public CompletableFuture<ListSearchJobsResponse> listSearchJobs(ListSearchJobsRequest listSearchJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListSearchJobsResponse> listSearchJobs(Consumer<ListSearchJobsRequest.Builder> listSearchJobsRequest) {
        return this.listSearchJobs((ListSearchJobsRequest)((Object)((ListSearchJobsRequest.Builder)ListSearchJobsRequest.builder().applyMutation(listSearchJobsRequest)).build()));
    }

    default public ListSearchJobsPublisher listSearchJobsPaginator(ListSearchJobsRequest listSearchJobsRequest) {
        return new ListSearchJobsPublisher(this, listSearchJobsRequest);
    }

    default public ListSearchJobsPublisher listSearchJobsPaginator(Consumer<ListSearchJobsRequest.Builder> listSearchJobsRequest) {
        return this.listSearchJobsPaginator((ListSearchJobsRequest)((Object)((ListSearchJobsRequest.Builder)ListSearchJobsRequest.builder().applyMutation(listSearchJobsRequest)).build()));
    }

    default public CompletableFuture<ListSearchResultExportJobsResponse> listSearchResultExportJobs(ListSearchResultExportJobsRequest listSearchResultExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListSearchResultExportJobsResponse> listSearchResultExportJobs(Consumer<ListSearchResultExportJobsRequest.Builder> listSearchResultExportJobsRequest) {
        return this.listSearchResultExportJobs((ListSearchResultExportJobsRequest)((Object)((ListSearchResultExportJobsRequest.Builder)ListSearchResultExportJobsRequest.builder().applyMutation(listSearchResultExportJobsRequest)).build()));
    }

    default public ListSearchResultExportJobsPublisher listSearchResultExportJobsPaginator(ListSearchResultExportJobsRequest listSearchResultExportJobsRequest) {
        return new ListSearchResultExportJobsPublisher(this, listSearchResultExportJobsRequest);
    }

    default public ListSearchResultExportJobsPublisher listSearchResultExportJobsPaginator(Consumer<ListSearchResultExportJobsRequest.Builder> listSearchResultExportJobsRequest) {
        return this.listSearchResultExportJobsPaginator((ListSearchResultExportJobsRequest)((Object)((ListSearchResultExportJobsRequest.Builder)ListSearchResultExportJobsRequest.builder().applyMutation(listSearchResultExportJobsRequest)).build()));
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public CompletableFuture<StartSearchJobResponse> startSearchJob(StartSearchJobRequest startSearchJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartSearchJobResponse> startSearchJob(Consumer<StartSearchJobRequest.Builder> startSearchJobRequest) {
        return this.startSearchJob((StartSearchJobRequest)((Object)((StartSearchJobRequest.Builder)StartSearchJobRequest.builder().applyMutation(startSearchJobRequest)).build()));
    }

    default public CompletableFuture<StartSearchResultExportJobResponse> startSearchResultExportJob(StartSearchResultExportJobRequest startSearchResultExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StartSearchResultExportJobResponse> startSearchResultExportJob(Consumer<StartSearchResultExportJobRequest.Builder> startSearchResultExportJobRequest) {
        return this.startSearchResultExportJob((StartSearchResultExportJobRequest)((Object)((StartSearchResultExportJobRequest.Builder)StartSearchResultExportJobRequest.builder().applyMutation(startSearchResultExportJobRequest)).build()));
    }

    default public CompletableFuture<StopSearchJobResponse> stopSearchJob(StopSearchJobRequest stopSearchJobRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<StopSearchJobResponse> stopSearchJob(Consumer<StopSearchJobRequest.Builder> stopSearchJobRequest) {
        return this.stopSearchJob((StopSearchJobRequest)((Object)((StopSearchJobRequest.Builder)StopSearchJobRequest.builder().applyMutation(stopSearchJobRequest)).build()));
    }

    default public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    default public BackupSearchServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    public static BackupSearchAsyncClient create() {
        return (BackupSearchAsyncClient)BackupSearchAsyncClient.builder().build();
    }

    public static BackupSearchAsyncClientBuilder builder() {
        return new DefaultBackupSearchAsyncClientBuilder();
    }
}

